/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite potET", author="Sven Kralisch", date="30. September 2005", description="This component calculates the potential ET after Hamon based on time, temperature and day length")
public class HamonET
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current temperature")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Length of a day in this month")
    public Attribute.Double daylength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calibration Parameter for ET", lowerBound=0.5, upperBound=1.5, defaultValue="1.0")
    public Attribute.Double cal_ET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Resulting potential ET")
    public Attribute.Double potET;

    public void run() {
        double temp = this.temp.getValue();
        double daylength = this.daylength.getValue();
        double Wt = 4.95 * Math.exp(0.062 * temp) / 100.0;
        double D2 = daylength / 12.0 * (daylength / 12.0);
        double potET = 0.55 * (double)this.time.getActualMaximum(5) * D2 * Wt;
        if (potET <= 0.0) {
            potET = 0.0;
        }
        if (temp <= -1.0) {
            potET = 0.0;
        }
        this.potET.setValue((potET *= 25.4) * this.cal_ET.getValue());
    }
}

