/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import ucar.mcidas.GRIDnav;
import ucar.mcidas.McIDASException;
import ucar.nc2.iosp.grid.GridDefRecord;

public class McGridDefRecord
extends GridDefRecord {
    int[] vals;
    private static final int PSEUDO_MERCATOR = 1;
    private static final int PS_OR_LAMBERT_CONIC = 2;
    private static final int EQUIDISTANT = 3;
    private static final int PSEUDO_MERCATOR_GENERAL = 4;
    private static final int NO_NAV = 5;
    private static final int LAMBERT_CONFORMAL_TANGENT = 6;

    public McGridDefRecord() {
    }

    public McGridDefRecord(int[] words) {
        this.setValues(words);
    }

    public void setValues(int[] values) {
        this.vals = values;
        this.setParams();
        this.addParam("GDSkey", this.toString());
    }

    public String toString() {
        return this.getParam("ProjFlag") + " X:" + this.getParam("Nx") + " Y:" + this.getParam("Ny");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof McGridDefRecord)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void setParams() {
        try {
            GRIDnav nav = new GRIDnav(this.vals);
            int gridType = this.vals[33];
            int navType = gridType % 10;
            this.addParam("Proj", String.valueOf(navType));
            boolean wierd = gridType / 10 == 1;
            int ny = this.vals[1];
            int nx = this.vals[2];
            this.addParam("ProjFlag", this.getProjName(navType));
            this.addParam("Nx", String.valueOf(nx));
            this.addParam("Ny", String.valueOf(ny));
            double[][] input = nav.isFlippedRowCoordinates() ? new double[][]{{1.0, nx}, {1.0, ny}} : new double[][]{{1.0, nx}, {ny, 1.0}};
            double[][] llur = nav.toLatLon(input);
            this.addParam("La1", String.valueOf(llur[0][0]));
            this.addParam("Lo1", String.valueOf(llur[1][0]));
            this.addParam("La2", String.valueOf(llur[0][1]));
            this.addParam("Lo2", String.valueOf(llur[1][1]));
            switch (navType) {
                case 1: 
                case 4: {
                    double ginct = (double)this.vals[38] / 10000.0;
                    this.addParam("Latin", String.valueOf(20));
                    break;
                }
                case 2: {
                    double xspace = this.vals[36];
                    double xqlon = (double)(-this.vals[37]) / 10000.0;
                    double xt1 = (double)this.vals[38] / 10000.0;
                    double xt2 = (double)this.vals[39] / 10000.0;
                    this.addParam("Latin1", String.valueOf(xt1));
                    this.addParam("LoV", String.valueOf(xqlon));
                    this.addParam("Latin2", String.valueOf(xt2));
                    this.addParam("Dx", String.valueOf(xspace));
                    this.addParam("Dy", String.valueOf(xspace));
                    break;
                }
                case 3: {
                    double glamx = (double)this.vals[34] / 10000.0;
                    double glomx = (double)(-this.vals[35]) / 10000.0;
                    double xspace = (double)this.vals[37] / 1000.0;
                    double yspace = (double)this.vals[38] / 1000.0;
                    this.addParam("La1", String.valueOf(glamx));
                    this.addParam("Lo1", String.valueOf(glomx));
                    this.addParam("Dx", String.valueOf(xspace));
                    this.addParam("Dy", String.valueOf(yspace));
                    break;
                }
                case 6: {
                    double xspace = this.vals[36];
                    double xqlon = (double)(-this.vals[37]) / 10000.0;
                    double xt1 = (double)this.vals[38] / 10000.0;
                    double xt2 = (double)this.vals[39] / 10000.0;
                    if (Double.compare(xt2, -2.139062144E9) == 0 || xt2 == 0.0) {
                        xt2 = xt1;
                    }
                    this.addParam("Latin1", String.valueOf(xt1));
                    this.addParam("LoV", String.valueOf(xqlon));
                    this.addParam("Latin2", String.valueOf(xt2));
                    this.addParam("Dx", String.valueOf(xspace));
                    this.addParam("Dy", String.valueOf(xspace));
                    break;
                }
            }
        }
        catch (McIDASException me) {
            throw new RuntimeException("couldn't set nav");
        }
    }

    @Override
    public String getGroupName() {
        return this.getParam("ProjFlag") + "_" + this.getParam("Nx") + "x" + this.getParam("Ny");
    }

    public String getProjName(int type) {
        String projName;
        switch (type) {
            case 1: 
            case 4: {
                projName = "MERC";
                break;
            }
            case 2: {
                projName = this.vals[38] == this.vals[39] ? "PS" : "CONF";
                break;
            }
            case 3: {
                projName = "EQUI";
                break;
            }
            case 6: {
                projName = "CONF";
                break;
            }
            default: {
                projName = "NAV" + type;
            }
        }
        return projName;
    }
}

