/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.iosp.gempak.GempakStationFileIOSP;
import ucar.nc2.iosp.gempak.GempakSurfaceFileReader;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GempakSurfaceIOSP
extends GempakStationFileIOSP {
    @Override
    protected AbstractGempakStationFileReader makeStationReader() {
        return new GempakSurfaceFileReader();
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (!super.isValidFile(raf)) {
            return false;
        }
        return this.gemreader.getFileSubType().equals("standard") || this.gemreader.getFileSubType().equals("ship");
    }

    @Override
    public String getFileTypeId() {
        return "GempakSurface";
    }

    @Override
    public String getFileTypeDescription() {
        return "GEMPAK Surface Obs Data";
    }

    @Override
    public String getCFFeatureType() {
        if (this.gemreader.getFileSubType().equals("ship")) {
            return CF.FeatureType.point.toString();
        }
        return CF.FeatureType.timeSeries.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (this.gemreader == null) {
            return null;
        }
        Array array = null;
        if (this.gemreader.getFileSubType().equals("ship")) {
            array = this.readShipData(v2, section);
        } else if (this.gemreader.getFileSubType().equals("standard")) {
            array = this.readStandardData(v2, section);
        }
        return array;
    }

    private Array readStandardData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            ImmutableList<StructureMembers.Member> mbers = members.getMembers();
            int i = 0;
            int totalNumBytes = 0;
            for (StructureMembers.Member member : mbers) {
                member.setDataParam(4 * i++);
                int numBytes = member.getDataType().getSize();
                totalNumBytes += numBytes;
            }
            members.setStructureSize(totalNumBytes);
            float[] missing = new float[mbers.size()];
            int missnum = 0;
            for (Variable v : pdata.getVariables()) {
                Attribute att = v.findAttribute("missing_value");
                missing[missnum++] = att == null ? -9999.0f : att.getNumericValue().floatValue();
            }
            Range stationRange = section.getRange(0);
            Range timeRange = section.getRange(1);
            int size = stationRange.length() * timeRange.length();
            byte[] bytes = new byte[totalNumBytes * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            for (int stnIdx : stationRange) {
                for (int timeIdx : timeRange) {
                    GempakFileReader.RData vals = this.gemreader.DM_RDTR(timeIdx + 1, stnIdx + 1, "SFDT");
                    if (vals == null) {
                        int k = 0;
                        for (StructureMembers.Member member : mbers) {
                            if (member.getDataType() == DataType.FLOAT) {
                                buf.putFloat(missing[k]);
                            } else {
                                buf.put((byte)1);
                            }
                            ++k;
                        }
                        continue;
                    }
                    float[] reals = vals.data;
                    int var = 0;
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) != null) {
                            buf.putFloat(reals[var]);
                        }
                        ++var;
                    }
                    buf.put((byte)0);
                }
            }
        }
        return array;
    }

    private Array readShipData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            boolean needToReadData;
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            ImmutableList<StructureMembers.Member> mbers = members.getMembers();
            int ssize = 0;
            List<String> stnKeyNames = this.gemreader.getStationKeyNames();
            for (StructureMembers.Member member : mbers) {
                if (stnKeyNames.contains(member.getName())) {
                    int varSize = this.getStnVarSize(member.getName());
                    member.setDataParam(ssize);
                    ssize += varSize;
                    continue;
                }
                if (member.getName().equals("time")) {
                    member.setDataParam(ssize);
                    ssize += 8;
                    continue;
                }
                if (member.getName().equals("_isMissing")) {
                    member.setDataParam(ssize);
                    ++ssize;
                    continue;
                }
                member.setDataParam(ssize);
                ssize += 4;
            }
            members.setStructureSize(ssize);
            Range recordRange = section.getRange(0);
            int size = recordRange.length();
            byte[] bytes = new byte[ssize * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            List<GempakStation> stationList = this.gemreader.getStations();
            List<Date> dateList = this.gemreader.getDates();
            boolean bl = needToReadData = !pdata.isSubset();
            if (!needToReadData) {
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) == null) continue;
                    needToReadData = true;
                    break;
                }
            }
            Iterator<Object> iterator = recordRange.iterator();
            while (iterator.hasNext()) {
                int recIdx = (Integer)iterator.next();
                GempakStation stn = stationList.get(recIdx);
                for (String varname : stnKeyNames) {
                    if (members.findMember(varname) == null) continue;
                    Object temp = null;
                    switch (varname) {
                        case "STID": {
                            temp = StringUtil2.padRight(stn.getName(), 8);
                            break;
                        }
                        case "STNM": {
                            buf.putInt(stn.getSTNM());
                            break;
                        }
                        case "SLAT": {
                            buf.putFloat((float)stn.getLatitude());
                            break;
                        }
                        case "SLON": {
                            buf.putFloat((float)stn.getLongitude());
                            break;
                        }
                        case "SELV": {
                            buf.putFloat((float)stn.getAltitude());
                            break;
                        }
                        case "STAT": {
                            temp = StringUtil2.padRight(stn.getSTAT(), 2);
                            break;
                        }
                        case "COUN": {
                            temp = StringUtil2.padRight(stn.getCOUN(), 2);
                            break;
                        }
                        case "STD2": {
                            temp = StringUtil2.padRight(stn.getSTD2(), 4);
                            break;
                        }
                        case "SPRI": {
                            buf.putInt(stn.getSPRI());
                            break;
                        }
                        case "SWFO": {
                            temp = StringUtil2.padRight(stn.getSWFO(), 4);
                            break;
                        }
                        case "WFO2": {
                            temp = StringUtil2.padRight(stn.getWFO2(), 4);
                        }
                    }
                    if (temp == null) continue;
                    buf.put(((String)temp).getBytes(StandardCharsets.UTF_8));
                }
                if (members.findMember("time") != null) {
                    Date time = dateList.get(recIdx);
                    buf.putDouble((double)time.getTime() / 1000.0);
                }
                if (!needToReadData) continue;
                int column = stn.getIndex();
                GempakFileReader.RData vals = this.gemreader.DM_RDTR(1, column, "SFDT");
                if (vals == null) {
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) == null) continue;
                        buf.putFloat(-9999.0f);
                    }
                    buf.put((byte)1);
                    continue;
                }
                float[] reals = vals.data;
                int var = 0;
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) != null) {
                        buf.putFloat(reals[var]);
                    }
                    ++var;
                }
                buf.put((byte)0);
            }
        }
        return array;
    }

    @Override
    protected void fillNCFile() throws IOException {
        String fileType;
        switch (fileType = this.gemreader.getFileSubType()) {
            case "standard": {
                this.buildStandardFile();
                break;
            }
            case "ship": {
                this.buildShipFile();
                break;
            }
            default: {
                this.buildClimateFile();
            }
        }
    }

    private void buildStandardFile() {
        List<GempakStation> stations = this.gemreader.getStations();
        Dimension station = new Dimension("station", stations.size());
        this.ncfile.addDimension(null, station);
        this.ncfile.addDimension(null, DIM_LEN8);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, station);
        for (Variable stnVar : stationVars) {
            this.ncfile.addVariable(null, stnVar);
        }
        List<Date> timeList = this.gemreader.getDates();
        int numTimes = timeList.size();
        Dimension times = new Dimension("time", numTimes);
        this.ncfile.addDimension(null, times);
        Variable timeVar = new Variable(this.ncfile, null, null, "time", DataType.DOUBLE, "time");
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "time"));
        ArrayDouble.D1 varArray = new ArrayDouble.D1(numTimes);
        int i = 0;
        for (Date date : timeList) {
            varArray.set(i, (double)date.getTime() / 1000.0);
            ++i;
        }
        timeVar.setCachedData(varArray, false);
        this.ncfile.addVariable(null, timeVar);
        ArrayList<Dimension> stationTime = new ArrayList<Dimension>();
        stationTime.add(station);
        stationTime.add(times);
        Structure sfData = this.makeStructure("SFDT", stationTime, true);
        if (sfData == null) {
            return;
        }
        sfData.addAttribute(new Attribute("coordinates", "time SLAT SLON SELV"));
        this.ncfile.addVariable(null, sfData);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.timeSeries.toString()));
    }

    private void buildShipFile() {
        int numObs;
        List<GempakStation> stations = this.gemreader.getStations();
        Dimension record = new Dimension("record", numObs, true, (numObs = stations.size()) == 0, false);
        this.ncfile.addDimension(null, record);
        ArrayList<Dimension> records = new ArrayList<Dimension>(1);
        records.add(record);
        Variable timeVar = new Variable(this.ncfile, null, null, "time", DataType.DOUBLE, (String)null);
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "time"));
        this.ncfile.addDimension(null, DIM_LEN8);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, null);
        List<GempakParameter> params = this.gemreader.getParameters("SFDT");
        if (params == null) {
            return;
        }
        Structure sVar = new Structure(this.ncfile, null, null, "Obs");
        sVar.setDimensions(records);
        boolean hasElevation = false;
        for (Variable stnVar : stationVars) {
            if (stnVar.getShortName().equals("SELV")) {
                hasElevation = true;
            }
            sVar.addMemberVariable(stnVar);
        }
        sVar.addMemberVariable(timeVar);
        for (GempakParameter param : params) {
            Variable var = this.makeParamVariable(param, null);
            sVar.addMemberVariable(var);
        }
        sVar.addMemberVariable(this.makeMissingVariable());
        String coords = "Obs.time Obs.SLAT Obs.SLON";
        if (hasElevation) {
            coords = coords + " Obs.SELV";
        }
        sVar.addAttribute(new Attribute("coordinates", coords));
        this.ncfile.addVariable(null, sVar);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.point.toString()));
    }

    private void buildClimateFile() {
    }
}

