/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class BufrDataDescriptionSection {
    private final long offset;
    private final int ndatasets;
    private final int datatype;
    private final List<Short> descriptors = new ArrayList<Short>();

    public BufrDataDescriptionSection(RandomAccessFile raf) throws IOException {
        this.offset = raf.getFilePointer();
        int length = BufrNumbers.uint3(raf);
        long EOS = this.offset + (long)length;
        raf.read();
        this.ndatasets = BufrNumbers.uint2(raf);
        this.datatype = raf.read();
        int ndesc = (length - 7) / 2;
        for (int i = 0; i < ndesc; ++i) {
            int ch1 = raf.read();
            int ch2 = raf.read();
            short fxy = (short)((ch1 << 8) + ch2);
            this.descriptors.add(fxy);
        }
        raf.seek(EOS);
    }

    public final long getOffset() {
        return this.offset;
    }

    public final int getNumberDatasets() {
        return this.ndatasets;
    }

    public final int getDataType() {
        return this.datatype;
    }

    public boolean isObserved() {
        return (this.datatype & 0x80) != 0;
    }

    public boolean isCompressed() {
        return (this.datatype & 0x40) != 0;
    }

    public final List<Short> getDataDescriptors() {
        return this.descriptors;
    }

    public final List<String> getDescriptors() {
        ArrayList<String> desc = new ArrayList<String>();
        for (short fxy : this.descriptors) {
            desc.add(Descriptor.makeString(fxy));
        }
        return desc;
    }
}

