/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.internal.ncml.AggDatasetOuter;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

abstract class AggregationOuter
extends Aggregation
implements ProxyReader {
    protected static boolean debugCache;
    protected static boolean debugInvocation;
    protected static boolean debugStride;
    public static int invocation;
    protected List<String> aggVarNames = new ArrayList<String>();
    protected List<VariableDS.Builder> aggVars = new ArrayList<VariableDS.Builder>();
    private int totalCoords;
    protected List<CacheVar> cacheList = new ArrayList<CacheVar>();
    protected boolean timeUnitsChange;

    AggregationOuter(NetcdfDataset.Builder ncd, String dimName, Aggregation.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    void setTimeUnitsChange(boolean timeUnitsChange) {
        this.timeUnitsChange = timeUnitsChange;
        if (timeUnitsChange) {
            this.isDate = true;
        }
    }

    public void addVariable(String varName) {
        this.aggVarNames.add(varName);
    }

    void addVariableFromGlobalAttribute(String varName, String orgName) {
        this.cacheList.add(new PromoteVar(varName, orgName));
    }

    void addVariableFromGlobalAttributeCompose(String varName, String format, String gattNames) {
        this.cacheList.add(new PromoteVarCompose(varName, format, gattNames));
    }

    void addCacheVariable(String varName, DataType dtype) {
        if (this.findCacheVariable(varName) != null) {
            return;
        }
        this.cacheList.add(new CacheVar(varName, dtype));
    }

    CacheVar findCacheVariable(String varName) {
        for (CacheVar cv : this.cacheList) {
            if (!cv.varName.equals(varName)) continue;
            return cv;
        }
        return null;
    }

    List<String> getAggVariableNames() {
        return this.aggVarNames;
    }

    protected void buildCoords(CancelTask cancelTask) throws IOException {
        AggDatasetOuter dod;
        List<AggDataset> nestedDatasets = this.getDatasets();
        if (this.type == Aggregation.Type.forecastModelRunCollection) {
            for (AggDataset nested : nestedDatasets) {
                dod = (AggDatasetOuter)nested;
                dod.ncoord = 1;
            }
        }
        this.totalCoords = 0;
        for (AggDataset nested : nestedDatasets) {
            dod = (AggDatasetOuter)nested;
            this.totalCoords += dod.setStartEnd(this.totalCoords, cancelTask);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readTimeCoordinates(Variable.Builder timeAxis, CancelTask cancelTask) throws IOException {
        ArrayList<CalendarDate> dateList = new ArrayList<CalendarDate>();
        String timeUnits = null;
        Enum calendar = null;
        Calendar calendarToCheck = null;
        for (AggDataset dataset : this.getDatasets()) {
            try (NetcdfFile ncfile = dataset.acquireFile(cancelTask);){
                Variable v = ncfile.findVariable(timeAxis.shortName);
                if (v == null) {
                    logger.warn("readTimeCoordinates: variable = " + timeAxis.shortName + " not found in file " + dataset.getLocation());
                    return;
                }
                VariableDS vds = v instanceof VariableDS ? (VariableDS)v : new VariableDS(null, v, true);
                CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(null, vds, null);
                dateList.addAll(timeCoordVar.getCalendarDates());
                if (timeUnits == null) {
                    timeUnits = v.getUnitsString();
                    if (timeUnits == null) {
                        String msg = String.format("Time coordinate %s must have a non-null unit attribute.", timeAxis.shortName);
                        logger.error(msg);
                        if (cancelTask == null) throw new UnsupportedOperationException(msg);
                        cancelTask.setError(msg);
                        throw new UnsupportedOperationException(msg);
                    }
                    calendar = timeCoordVar.getCalendarFromAttribute();
                } else {
                    calendarToCheck = timeCoordVar.getCalendarFromAttribute();
                    if (!this.calendarsEquivalent((Calendar)calendar, calendarToCheck)) {
                        String msg = String.format("Inequivalent calendars found across the aggregation: calendar %s is not equivalent to %s.", new Object[]{calendar, calendarToCheck});
                        logger.error(msg);
                        if (cancelTask == null) throw new UnsupportedOperationException(msg);
                        cancelTask.setError(msg);
                        throw new UnsupportedOperationException(msg);
                    }
                }
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        int[] shape = new int[]{dateList.size()};
        DataType coordType = timeAxis.dataType == DataType.STRING ? DataType.STRING : DataType.DOUBLE;
        Array timeCoordVals = Array.factory(coordType, shape);
        IndexIterator ii = timeCoordVals.getIndexIterator();
        if (timeAxis.dataType == DataType.STRING) {
            for (CalendarDate date : dateList) {
                ii.setObjectNext(date.toString());
            }
        } else {
            timeAxis.setDataType(DataType.DOUBLE);
            String calendarName = calendar != null ? calendar.name() : null;
            CalendarDateUnit calendarDateUnit = CalendarDateUnit.of(calendarName, timeUnits);
            timeAxis.addAttribute(new Attribute("units", calendarDateUnit.getUdUnit()));
            timeAxis.addAttribute(new Attribute("calendar", calendarDateUnit.getCalendar().name()));
            for (CalendarDate date : dateList) {
                double val = calendarDateUnit.makeOffsetFromRefDate(date);
                ii.setDoubleNext(val);
            }
        }
        timeAxis.setCachedData(timeCoordVals, true);
    }

    private boolean calendarsEquivalent(Calendar a, Calendar b) {
        boolean equivalent = false;
        if (a != null) {
            if (b != null) {
                equivalent = b.equals((Object)a);
            }
        } else {
            equivalent = b == null;
        }
        return equivalent;
    }

    protected int getTotalCoords() {
        return this.totalCoords;
    }

    protected void promoteGlobalAttributes(AggDatasetOuter typicalDataset) throws IOException {
        for (CacheVar cv : this.cacheList) {
            if (!(cv instanceof PromoteVar)) continue;
            PromoteVar pv = (PromoteVar)cv;
            Array data = pv.read(typicalDataset);
            if (data == null) {
                throw new IOException("cant read " + typicalDataset);
            }
            pv.dtype = DataType.getType(data);
            VariableDS.Builder promotedVar = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(pv.varName)).setDataType(pv.dtype)).setParentGroupBuilder(this.ncDataset.rootGroup)).setDimensionsByName(this.dimName);
            this.ncDataset.rootGroup.addVariable(promotedVar);
            promotedVar.setProxyReader(this);
            promotedVar.setSPobject(pv);
        }
    }

    @Override
    public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        long size;
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            logger.warn("Original type = {} mainv type= {}", (Object)dtype, (Object)mainv.getDataType());
        }
        if ((size = section.computeSize()) == mainv.getSize()) {
            return this.reallyRead(mainv, cancelTask);
        }
        DataType dtype2 = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            Array cacheArray = pv.read(section, cancelTask);
            return MAMath.convert(cacheArray, dtype2);
        }
        Array sectionData = Array.factory(dtype2, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        if (debug) {
            System.out.println("   agg wants range=" + mainv.getFullName() + "(" + joinRange + ")");
        }
        List<AggDataset> nestedDatasets = this.getDatasets();
        for (AggDataset nested : nestedDatasets) {
            Array varData;
            AggDatasetOuter dod = (AggDatasetOuter)nested;
            Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
            if (nestedJoinRange == null) continue;
            if (this.type == Aggregation.Type.joinNew || this.type == Aggregation.Type.forecastModelRunCollection) {
                varData = dod.read(mainv, cancelTask, innerSection);
            } else {
                nestedSection.set(0, nestedJoinRange);
                varData = dod.read(mainv, cancelTask, nestedSection);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            varData = MAMath.convert(varData, dtype2);
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return sectionData;
    }

    @Override
    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            logger.warn("Original type = {} mainv type= {}", (Object)dtype, (Object)mainv.getDataType());
        }
        dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            try {
                Array cacheArray = pv.read(mainv.getShapeAsSection(), cancelTask);
                return MAMath.convert(cacheArray, dtype);
            }
            catch (InvalidRangeException e) {
                logger.error("readAgg " + this.getLocation(), e);
                throw new IllegalArgumentException("readAgg " + this.getLocation(), e);
            }
        }
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        List<AggDataset> nestedDatasets = this.getDatasets();
        if (executor != null) {
            ExecutorCompletionService<Result> completionService = new ExecutorCompletionService<Result>(executor);
            int count = 0;
            for (AggDataset vnested : nestedDatasets) {
                completionService.submit(new ReaderTask(vnested, mainv, cancelTask, count++));
            }
            try {
                int n = nestedDatasets.size();
                for (int i = 0; i < n; ++i) {
                    Result r = (Result)completionService.take().get();
                    if (r == null) continue;
                    r.data = MAMath.convert(r.data, dtype);
                    int size = (int)r.data.getSize();
                    Array.arraycopy(r.data, 0, allData, size * r.index, size);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            for (AggDataset vnested : nestedDatasets) {
                Array varData = vnested.read(mainv, cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    return null;
                }
                varData = MAMath.convert(varData, dtype);
                Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
                destPos = (int)((long)destPos + varData.getSize());
            }
        }
        return allData;
    }

    @Override
    protected AggDataset makeDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        return new AggDatasetOuter(this, cacheName, location, id, ncoordS, coordValueS, enhance, reader);
    }

    @Override
    protected AggDataset makeDataset(MFile dset) {
        return new AggDatasetOuter(this, dset);
    }

    @Override
    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        f.format("  timeUnitsChange=%s%n", this.timeUnitsChange);
        f.format("  totalCoords=%d%n", this.totalCoords);
        if (!this.aggVarNames.isEmpty()) {
            f.format("  Aggregation Variables specified in NcML%n", new Object[0]);
            for (String string : this.aggVarNames) {
                f.format("   %s%n", string);
            }
        }
        f.format("%nAggregation Variables%n", new Object[0]);
        for (VariableDS.Builder builder : this.aggVars) {
            f.format("   %s %s%n", builder.shortName, String.join((CharSequence)",", builder.getDimensionNames()));
        }
        if (!this.cacheList.isEmpty()) {
            f.format("%nCache Variables%n", new Object[0]);
            for (CacheVar cacheVar : this.cacheList) {
                f.format("   %s%n", cacheVar);
            }
        }
        f.format("%nVariable Proxies%n", new Object[0]);
        for (Variable.Builder builder : this.ncDataset.rootGroup.vbuilders) {
            f.format("   %20s proxy %s%n", builder.shortName, builder.proxyReader == null ? "" : builder.proxyReader.getClass().getName());
        }
    }

    class PromoteVarCompose
    extends PromoteVar {
        String format;
        String[] gattNames;

        PromoteVarCompose(String varName, String format, String gattNames) {
            super(varName, DataType.STRING);
            this.format = format;
            this.gattNames = gattNames.split(" ");
            if (format == null) {
                throw new IllegalArgumentException("Missing format string (java.util.Formatter)");
            }
        }

        @Override
        protected Array read(AggDatasetOuter dset, NetcdfFile ncfile) {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String gattName : this.gattNames) {
                Attribute att = ncfile.findGlobalAttribute(gattName);
                if (att == null) {
                    throw new IllegalArgumentException("Unknown attribute name= " + gattName);
                }
                vals.add(att.getValue(0));
            }
            Formatter f = new Formatter();
            f.format(this.format, vals.toArray());
            String result = f.toString();
            Array allData = Array.factory(this.dtype, new int[]{dset.ncoord});
            for (int i = 0; i < dset.ncoord; ++i) {
                allData.setObject(i, (Object)result);
            }
            this.putData(dset.getId(), allData);
            return allData;
        }
    }

    class PromoteVar
    extends CacheVar {
        String gattName;

        protected PromoteVar(String varName, DataType dtype) {
            super(varName, dtype);
        }

        PromoteVar(String varName, String gattName) {
            super(varName, null);
            this.gattName = gattName != null ? gattName : varName;
        }

        @Override
        protected Array read(AggDatasetOuter dset, NetcdfFile ncfile) {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            Attribute att = ncfile.findGlobalAttribute(this.gattName);
            if (att == null) {
                throw new IllegalArgumentException("Unknown attribute name= " + this.gattName);
            }
            data = att.getValues();
            if (this.dtype == null) {
                this.dtype = DataType.getType(data);
            }
            if (dset.ncoord == 1) {
                this.putData(dset.getId(), data);
            } else {
                Array allData = Array.factory(this.dtype, new int[]{dset.ncoord});
                for (int i = 0; i < dset.ncoord; ++i) {
                    Array.arraycopy(data, 0, allData, i, 1);
                }
                this.putData(dset.getId(), allData);
                data = allData;
            }
            return data;
        }
    }

    class CoordValueVar
    extends CacheVar {
        String units;
        DateUnit du;

        CoordValueVar(String varName, DataType dtype, String units) {
            super(varName, dtype);
            this.units = units;
            try {
                this.du = new DateUnit(units);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected Array read(AggDatasetOuter dset) throws IOException {
            Array data = this.readCached(dset);
            if (data != null) {
                return data;
            }
            return super.read(dset);
        }

        @Override
        protected Array read(AggDatasetOuter dset, NetcdfFile ncfile) throws IOException {
            Array data = this.readCached(dset);
            if (data != null) {
                return data;
            }
            return super.read(dset, ncfile);
        }

        private Array readCached(AggDatasetOuter dset) {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            data = Array.factory(this.dtype, new int[]{dset.ncoord});
            IndexIterator ii = data.getIndexIterator();
            if (dset.coordValueDate != null) {
                if (this.dtype == DataType.STRING) {
                    ii.setObjectNext(dset.coordValue);
                } else if (this.du != null) {
                    double val = this.du.makeValue(dset.coordValueDate);
                    ii.setDoubleNext(val);
                }
                this.putData(dset.getId(), data);
                return data;
            }
            if (dset.coordValue != null) {
                if (dset.ncoord == 1) {
                    if (this.dtype == DataType.STRING) {
                        ii.setObjectNext(dset.coordValue);
                    } else {
                        double val = Double.parseDouble(dset.coordValue);
                        ii.setDoubleNext(val);
                    }
                } else {
                    int count = 0;
                    StringTokenizer stoker = new StringTokenizer(dset.coordValue, " ,");
                    while (stoker.hasMoreTokens()) {
                        String toke = stoker.nextToken();
                        if (this.dtype == DataType.STRING) {
                            ii.setObjectNext(toke);
                        } else {
                            double val = Double.parseDouble(toke);
                            ii.setDoubleNext(val);
                        }
                        ++count;
                    }
                    if (count != dset.ncoord) {
                        Aggregation.logger.error("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                        throw new IllegalArgumentException("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                    }
                }
                this.putData(dset.getId(), data);
                return data;
            }
            return null;
        }
    }

    class CacheVar {
        String varName;
        DataType dtype;
        private Map<String, Array> dataMap = new HashMap<String, Array>();

        CacheVar(String varName, DataType dtype) {
            this.varName = varName;
            this.dtype = dtype;
            if (varName == null) {
                throw new IllegalArgumentException("Missing variable name on cache var");
            }
        }

        public String toString() {
            return this.varName + " (" + this.getClass().getName() + ")";
        }

        void reset() {
            HashMap<String, Array> newMap = new HashMap<String, Array>();
            for (AggDataset ds : AggregationOuter.this.datasets) {
                String id = ds.getId();
                Array data = this.dataMap.get(id);
                if (data == null) continue;
                newMap.put(id, data);
            }
            this.dataMap = newMap;
        }

        Array read(Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            if (debugCache) {
                System.out.println("caching " + this.varName + " section= " + section);
            }
            Array allData = null;
            List<Range> ranges = section.getRanges();
            Range joinRange = section.getRange(0);
            Section innerSection = null;
            if (section.getRank() > 1) {
                innerSection = new Section(ranges.subList(1, ranges.size()));
            }
            int resultPos = 0;
            List<AggDataset> nestedDatasets = AggregationOuter.this.getDatasets();
            for (AggDataset vnested : nestedDatasets) {
                Array varData;
                AggDatasetOuter dod = (AggDatasetOuter)vnested;
                Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
                if (nestedJoinRange == null) continue;
                if (debugStride) {
                    System.out.printf("%d: %s [%d,%d) (%d) %f for %s%n", resultPos, nestedJoinRange, dod.aggStart, dod.aggEnd, dod.ncoord, (double)dod.aggStart / 8.0, vnested.getLocation());
                }
                if ((varData = this.read(dod)) == null) {
                    throw new IOException("cant read " + dod);
                }
                if ((AggregationOuter.this.type == Aggregation.Type.joinNew || AggregationOuter.this.type == Aggregation.Type.forecastModelRunCollection) && innerSection != null && varData.getSize() != innerSection.computeSize()) {
                    varData = varData.section(innerSection.getRanges());
                } else if (innerSection == null && varData.getSize() != (long)nestedJoinRange.length()) {
                    ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
                    nestedSection.set(0, nestedJoinRange);
                    varData = varData.section(nestedSection);
                }
                if (this.dtype == null) {
                    this.dtype = DataType.getType(varData);
                }
                if (allData == null) {
                    allData = Array.factory(this.dtype, section.getShape());
                    if (debugStride) {
                        System.out.printf("total result section = %s (%d)%n", section, Index.computeSize(section.getShape()));
                    }
                }
                int nelems = (int)varData.getSize();
                Array.arraycopy(varData, 0, allData, resultPos, nelems);
                resultPos += nelems;
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
            return allData;
        }

        protected void putData(String id, Array data) {
            this.dataMap.put(id, data);
        }

        protected Array getData(String id) {
            return this.dataMap.get(id);
        }

        protected Array read(AggDatasetOuter dset) throws IOException {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            if (AggregationOuter.this.type == Aggregation.Type.joinNew && !(this instanceof PromoteVar)) {
                return null;
            }
            try (NetcdfFile ncfile = dset.acquireFile(null);){
                Array array = this.read(dset, ncfile);
                return array;
            }
        }

        protected Array read(AggDatasetOuter dset, NetcdfFile ncfile) throws IOException {
            ++invocation;
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            if (AggregationOuter.this.type == Aggregation.Type.joinNew) {
                return null;
            }
            Variable v = ncfile.findVariable(this.varName);
            data = v.read();
            this.putData(dset.getId(), data);
            if (debugCache) {
                System.out.println("caching " + this.varName + " complete data");
            }
            return data;
        }
    }

    private static class Result {
        Array data;
        int index;

        Result(Array data, int index) {
            this.data = data;
            this.index = index;
        }
    }

    private static class ReaderTask
    implements Callable<Result> {
        AggDataset ds;
        Variable mainv;
        CancelTask cancelTask;
        int index;

        ReaderTask(AggDataset ds, Variable mainv, CancelTask cancelTask, int index) {
            this.ds = ds;
            this.mainv = mainv;
            this.cancelTask = cancelTask;
            this.index = index;
        }

        @Override
        public Result call() throws Exception {
            Array data = this.ds.read(this.mainv, this.cancelTask);
            return new Result(data, this.index);
        }
    }
}

