/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Deflate
extends Filter {
    private final int clevel;

    public Deflate(Map<String, Object> properties) {
        Object levelObj = properties.get("level");
        this.clevel = levelObj == null ? 1 : (levelObj instanceof String ? Integer.parseInt((String)levelObj) : ((Number)levelObj).intValue());
        this.validateLevel();
    }

    private void validateLevel() {
        if (this.clevel < 0 || this.clevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + this.clevel);
        }
    }

    @Override
    public byte[] encode(byte[] dataIn) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(dataIn.length);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)os, new Deflater(this.clevel));){
            dos.write(dataIn);
            dos.finish();
            dos.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Override
    public byte[] decode(byte[] dataIn) throws IOException {
        int read;
        ByteArrayInputStream in = new ByteArrayInputStream(dataIn);
        InflaterInputStream iis = new InflaterInputStream(in, new Inflater(), dataIn.length);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((read = iis.read()) != -1) {
            os.write(read);
        }
        in.close();
        iis.close();
        os.close();
        return os.toByteArray();
    }

    public static class Provider
    implements FilterProvider {
        private static final String name = "zlib";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Deflate(properties);
        }
    }
}

