/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.RandomAccessFile;
import ucar.atd.dorade.DoradeDescriptor;

class DoradeASIB
extends DoradeDescriptor {
    private float longitude;
    private float latitude;
    private float altitudeMSL;
    private float altitudeAGL;
    private float groundSpeedEW;
    private float groundSpeedNS;
    private float verticalVelocity;
    private float antennaHeading;
    private float rollAngle;
    private float pitchAngle;
    private float yawAngle;
    private float antennaScanAngle;
    private float antennaFixedAngle;
    private float uWind;
    private float vWind;
    private float wWind;
    private float headingChangeRate;
    private float pitchChangeRate;

    public DoradeASIB(RandomAccessFile file, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file, littleEndianData, "ASIB");
        this.longitude = this.grabFloat(data, 8);
        this.latitude = this.grabFloat(data, 12);
        this.altitudeMSL = this.grabFloat(data, 16);
        this.altitudeAGL = this.grabFloat(data, 20);
        this.groundSpeedEW = this.grabFloat(data, 24);
        this.groundSpeedNS = this.grabFloat(data, 28);
        this.verticalVelocity = this.grabFloat(data, 32);
        this.antennaHeading = this.grabFloat(data, 36);
        this.rollAngle = this.grabFloat(data, 40);
        this.pitchAngle = this.grabFloat(data, 44);
        this.yawAngle = this.grabFloat(data, 48);
        this.antennaScanAngle = this.grabFloat(data, 52);
        this.antennaFixedAngle = this.grabFloat(data, 56);
        this.uWind = this.grabFloat(data, 60);
        this.vWind = this.grabFloat(data, 64);
        this.wWind = this.grabFloat(data, 68);
        this.headingChangeRate = this.grabFloat(data, 72);
        this.pitchChangeRate = this.grabFloat(data, 76);
    }

    public String toString() {
        String s2 = "ASIB\n";
        s2 = s2 + "  longitude: " + this.longitude + "\n";
        s2 = s2 + "  latitude: " + this.latitude + "\n";
        s2 = s2 + "  altitude (MSL): " + this.altitudeMSL + "\n";
        s2 = s2 + "  altitude (AGL): " + this.altitudeAGL + "\n";
        s2 = s2 + "  EW ground speed: " + this.groundSpeedEW + "\n";
        s2 = s2 + "  NS ground speed: " + this.groundSpeedNS + "\n";
        s2 = s2 + "  vertical velocity: " + this.verticalVelocity + "\n";
        s2 = s2 + "  antenna heading: " + this.antennaHeading + "\n";
        s2 = s2 + "  roll: " + this.rollAngle + "\n";
        s2 = s2 + "  pitch: " + this.pitchAngle + "\n";
        s2 = s2 + "  yaw: " + this.yawAngle + "\n";
        s2 = s2 + "  scan angle: " + this.antennaScanAngle + "\n";
        s2 = s2 + "  fixed angle: " + this.antennaFixedAngle + "\n";
        s2 = s2 + "  u wind: " + this.uWind + "\n";
        s2 = s2 + "  v wind: " + this.vWind + "\n";
        s2 = s2 + "  w wind: " + this.wWind + "\n";
        s2 = s2 + "  heading change rate: " + this.headingChangeRate + "\n";
        s2 = s2 + "  pitch change rate: " + this.pitchChangeRate;
        return s2;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitudeMSL;
    }
}

