/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="TemperatureLapseRate", author="Santosh Nepal, Peter Krause", description="Regionalisation of Temp through general adiabatic ratedepends upon given adaiabatic rate")
@VersionComments(entries={@VersionComments.Entry(version="1.1", comment="Added functionality to handle the case that the closest station does not provide a valid value", date="2016-08-30")})
public class TemperatureLapseRate
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="station elevation")
    public Attribute.DoubleArray statElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity elevation")
    public Attribute.Double entityElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the measured input from a base station")
    public Attribute.DoubleArray inputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculated output for the modelling entity")
    public Attribute.Double outputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lapse rate per 100 m elevation difference")
    public Attribute.Double lapseRate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="position array to determine best weights")
    public Attribute.IntegerArray statOrder;

    public void init() {
    }

    public void run() {
        for (int i = 0; i < this.inputValue.getValue().length; ++i) {
            int closestStation = this.statOrder.getValue()[i];
            double input = this.inputValue.getValue()[closestStation];
            if (input == JAMS.getMissingDataValue()) continue;
            double elevationdiff = this.statElev.getValue()[closestStation] - this.entityElev.getValue();
            this.outputValue.setValue(elevationdiff * (this.lapseRate.getValue() / 100.0) + input);
            return;
        }
        this.getModel().getRuntime().sendHalt("No station with valid value found. Please check your inputs!");
    }

    public void cleanup() {
    }
}

