/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SoilWaterBalance", author="Peter Krause + Manfred Fink", version="1.1", description="Calculates a simplified soil water balance for each HRU add on soil water adjustment during runtime for automized adjustment to actual measurements")
public class SoilWaterBalance_2
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum MPS")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var actual MPS")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var relative saturation of MPS")
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU excess storage")
    public Attribute.Double excStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="infiltration capacity", defaultValue="Infinity")
    public Attribute.Double maxInf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="direct runoff")
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater recharge")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total runoff")
    public Attribute.Double totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="potential ET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual ET")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral-vertical distribution coefficient")
    public Attribute.Double latVertDist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral recession constant")
    public Attribute.Double recConst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ET reduction factor")
    public Attribute.Double linETRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum excStor")
    public Attribute.Double maxExcStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum percolation")
    public Attribute.Double maxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="PET adjustment factor")
    public Attribute.Double petMult;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Actuall soil moisture adjustment factor", defaultValue="1", lowerBound=0.0)
    public Attribute.Double act_soilMult;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date when soil moisture adjustment will be performed")
    public Attribute.Calendar adjustment_date;

    public void init() {
    }

    public void run() {
        double maxMPS;
        double deltaMPS;
        double k_factor = 1.0;
        double maxExcStor = 100000.0;
        double infCap = this.maxInf.getValue() * this.area.getValue();
        if (this.recConst != null) {
            k_factor = this.recConst.getValue();
        }
        if (this.maxExcStor != null) {
            maxExcStor = this.maxExcStor.getValue() * this.area.getValue();
        }
        double excStor = this.excStor.getValue();
        double actMPS = this.actMPS.getValue();
        double inflow = this.precip.getValue() + this.snowMelt.getValue();
        if (inflow <= (deltaMPS = (maxMPS = this.maxMPS.getValue()) - actMPS)) {
            if (inflow <= infCap) {
                actMPS += inflow;
                infCap = 0.0;
                inflow = 0.0;
            } else {
                actMPS += infCap;
                inflow -= infCap;
                infCap = 0.0;
            }
        } else if (deltaMPS <= infCap) {
            inflow -= deltaMPS;
            actMPS = maxMPS;
            infCap -= deltaMPS;
        } else {
            inflow -= infCap;
            actMPS += infCap;
            infCap = 0.0;
        }
        double actET = this.actET.getValue();
        double potET = this.potET.getValue() * this.petMult.getValue();
        this.potET.setValue(potET);
        double deltaET = potET - actET;
        if (inflow >= deltaET) {
            actET = potET;
            inflow -= deltaET;
            deltaET = 0.0;
        } else {
            actET += inflow;
            inflow = 0.0;
            deltaET = potET - actET;
        }
        double linRed = this.linETRed.getValue();
        double reduceET = 1.0;
        if (actMPS < linRed * maxMPS) {
            reduceET = actMPS / (linRed * maxMPS);
        }
        if (actMPS >= (deltaET *= reduceET)) {
            actET += deltaET;
            actMPS -= deltaET;
            deltaET = 0.0;
        } else {
            actET += actMPS;
            actMPS = 0.0;
        }
        deltaMPS = maxMPS - actMPS;
        if (inflow <= deltaMPS) {
            if (inflow < infCap) {
                actMPS += inflow;
                inflow = 0.0;
            } else {
                actMPS += infCap;
                inflow -= infCap;
                infCap = 0.0;
            }
        } else if (inflow <= infCap) {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        } else {
            actMPS += infCap;
            inflow -= infCap;
        }
        double dirQ = 0.0;
        double gwRecharge = 0.0;
        double slope_weight = Math.tan(this.slope.getValue() * (Math.PI / 180)) * this.latVertDist.getValue();
        if (slope_weight > 1.0) {
            slope_weight = 1.0;
        }
        if ((excStor += inflow * slope_weight) > maxExcStor) {
            dirQ = excStor - maxExcStor;
            excStor = maxExcStor;
        }
        double interflow = excStor * (1.0 / k_factor);
        excStor -= interflow;
        gwRecharge = inflow * (1.0 - slope_weight);
        double delta = 0.0;
        if (gwRecharge > this.maxPerc.getValue()) {
            delta = gwRecharge - this.maxPerc.getValue();
            interflow += delta;
            gwRecharge = this.maxPerc.getValue();
        }
        dirQ += interflow;
        if (this.adjustment_date.getValue() != null && this.adjustment_date.compareTo(this.date.getValue(), 3600000) == 0) {
            actMPS *= this.act_soilMult.getValue();
            actMPS = Math.min(actMPS, maxMPS);
        }
        this.actET.setValue(actET);
        this.actMPS.setValue(actMPS);
        this.satMPS.setValue(actMPS / maxMPS);
        this.excStor.setValue(excStor);
        this.gwRecharge.setValue(gwRecharge);
        this.dirQ.setValue(dirQ);
        this.totQ.setValue(dirQ + gwRecharge);
    }

    public void cleanup() {
    }
}

