/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class NashInputReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String workspace;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE)
    public Attribute.Double sq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the tmin input")
    public Attribute.Double ssq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the tmean input")
    public Attribute.Double bq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE)
    public Attribute.Double obsRunoff;
    private JAMSTableDataStore store;

    public void init() {
        String fName = null;
        try {
            fName = this.workspace.getValue() + File.separatorChar + this.fileName.getValue();
            BufferedReader reader = new BufferedReader(new FileReader(fName));
            String line = reader.readLine();
            if (line.charAt(0) == '#') {
                String string = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        this.store = new GenericDataReader(fName, true, 1, 2);
    }

    public void run() {
        if (this.store.hasNext()) {
            JAMSTableDataArray da = this.store.getNext();
            double[] vals = JAMSTableDataConverter.toDouble((JAMSTableDataArray)da);
            this.sq.setValue(vals[0]);
            this.ssq.setValue(vals[1]);
            this.bq.setValue(vals[2]);
            this.obsRunoff.setValue(vals[3]);
        }
    }

    public void cleanup() {
        this.store.close();
    }

    private Attribute.Calendar parseTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.setValue(timeArray[0] + "-" + timeArray[1] + "-" + timeArray[2] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }
}

