/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.sync;

import jams.server.client.WorkspaceController;
import jams.server.client.sync.DirectorySync;
import jams.server.entities.WorkspaceFileAssociation;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSync
implements Comparable {
    Logger logger = Logger.getLogger(FileSync.class.getName());
    WorkspaceController wc = null;
    DirectorySync parent;
    WorkspaceFileAssociation serverFile;
    String localFileName;
    String targetFileName;
    SyncMode syncMode;
    boolean isFileExisting;
    boolean isFileModified;
    boolean doSync = true;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");

    public FileSync() {
    }

    public FileSync(WorkspaceController wc, DirectorySync parent, WorkspaceFileAssociation serverFile, String localFileName) {
        this.wc = wc;
        this.parent = parent;
        this.serverFile = serverFile;
        this.setLocalFileName(localFileName);
        this.setTargetFileName(localFileName);
    }

    public boolean isModified() {
        return this.isFileModified;
    }

    public boolean isExisting() {
        return this.isFileExisting;
    }

    private boolean isIdenticalFile() throws IOException {
        if (this.isFileExisting) {
            String localHashCode = this.getLocalHashCode();
            String remoteHashCode = this.serverFile.getFile().getHash();
            if (localHashCode == null || !this.serverFile.getFile().isHashValid()) {
                return false;
            }
            return localHashCode.equals(remoteHashCode);
        }
        return false;
    }

    private String getLocalHashCode() throws IOException {
        File f = this.getLocalFile();
        if (f.exists() && f.isFile()) {
            return this.wc.getFileController().getHashCode(f);
        }
        return null;
    }

    protected final boolean isLocalFileExisting() {
        return this.getLocalFile().exists();
    }

    public DirectorySync getParent() {
        return this.parent;
    }

    public void applySyncFilter(SyncFilter filter) {
        this.setDoSync(filter.isFiltered(this), false);
    }

    public ArrayList<FileSync> getList(ArrayList<FileSync> list) {
        if (list == null) {
            list = new ArrayList();
        }
        list.add(this);
        return list;
    }

    public boolean isDoSync() {
        return this.doSync;
    }

    public void setDoSync(boolean doSync, boolean recursive) {
        this.doSync = doSync;
        if (this.parent != null && doSync && !this.parent.isDoSync()) {
            this.parent.setDoSync(doSync, false);
        }
    }

    protected void markAsModified() {
        this.isFileModified = true;
        if (this.parent != null) {
            this.parent.markAsModified();
        }
    }

    public FileSync getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public SyncMode[] getSyncOptions() {
        if (this.parent == null || this.parent.getSyncMode() == null || this.parent.getSyncMode() == SyncMode.UPDATE) {
            if (!this.isModified()) {
                return new SyncMode[]{SyncMode.NOTHING};
            }
            if (this.isExisting()) {
                return new SyncMode[]{SyncMode.UPDATE, SyncMode.DUPLICATE};
            }
            return new SyncMode[]{SyncMode.CREATE};
        }
        if (this.parent.getSyncMode() == SyncMode.NOTHING) {
            return new SyncMode[]{SyncMode.NOTHING};
        }
        if (this.parent.getSyncMode() == SyncMode.CREATE) {
            return new SyncMode[]{SyncMode.CREATE};
        }
        if (this.parent.getSyncMode() == SyncMode.DUPLICATE) {
            return new SyncMode[]{SyncMode.CREATE};
        }
        return null;
    }

    public void updateSyncMode() {
        SyncMode[] options;
        for (SyncMode option : options = this.getSyncOptions()) {
            if (!option.equals((Object)this.getSyncMode())) continue;
            return;
        }
        this.setSyncMode(options[0]);
    }

    public boolean setSyncMode(SyncMode mode) {
        SyncMode[] options;
        for (SyncMode option : options = this.getSyncOptions()) {
            if (!option.equals((Object)mode)) continue;
            if (this.syncMode == SyncMode.DUPLICATE) {
                this.setTargetFileName(this.getLocalFileName());
            }
            this.syncMode = mode;
            if (this.syncMode == SyncMode.DUPLICATE) {
                this.setLocalFileName(this.getLocalFileName().replace(".", this.sdf.format(new Date()) + "."));
            }
            return true;
        }
        return false;
    }

    public SyncMode getSyncMode() {
        return this.syncMode;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
        this.isFileExisting = this.isLocalFileExisting();
        try {
            this.isFileModified = !this.isIdenticalFile();
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, ioe.toString(), ioe);
            this.isFileModified = true;
        }
        this.doSync = false;
        if (this.isFileExisting && this.isFileModified) {
            this.doSync = true;
        }
        if (!this.isFileExisting) {
            this.doSync = true;
        }
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public File getLocalFile() {
        if (this.parent != null) {
            return new File(this.parent.getLocalFile(), this.localFileName);
        }
        return new File(this.localFileName);
    }

    public File getTargetFile() {
        if (this.parent != null) {
            return new File(this.parent.getTargetFile(), this.targetFileName);
        }
        return new File(this.targetFileName);
    }

    public WorkspaceFileAssociation getServerFile() {
        return this.serverFile;
    }

    public boolean synchronizeWorkspace(FileSync root) {
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof FileSync && this instanceof FileSync || o instanceof DirectorySync && this instanceof DirectorySync) {
            FileSync f = (FileSync)o;
            if (this.getServerFile() == null) {
                return 1;
            }
            if (this.getServerFile().getPath() == null) {
                return 1;
            }
            if (f.getServerFile() == null) {
                return -1;
            }
            if (f.getServerFile().getPath() == null) {
                return -1;
            }
            return this.getServerFile().getPath().compareTo(f.getServerFile().getPath());
        }
        if (o instanceof FileSync && this instanceof FileSync) {
            return -1;
        }
        return 1;
    }

    public static abstract class SyncFilter {
        public abstract boolean isFiltered(FileSync var1);

        public abstract boolean isFiltered(DirectorySync var1);
    }

    public static enum SyncMode {
        CREATE,
        UPDATE,
        DUPLICATE,
        NOTHING;

    }
}

