/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class ViewStreamDlg
extends JDialog {
    JTextArea text = new JTextArea(30, 80);
    JScrollPane pane = null;
    Thread t = null;
    final double LOOK_AHEAD = 1.2;
    BufferedReader reader = null;
    int currentView = 0;
    int currentRead = 0;

    public ViewStreamDlg(Dialog owner, InputStream is, String title) {
        super(owner);
        this.setTitle(title);
        this.reader = new BufferedReader(new InputStreamReader(is));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.pane = new JScrollPane(this.text);
        this.pane.setVerticalScrollBarPolicy(22);
        this.pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int endIndex = 0;
                if (ViewStreamDlg.this.text.getText().length() > 0) {
                    JViewport viewport = ViewStreamDlg.this.pane.getViewport();
                    Rectangle viewRect = viewport.getViewRect();
                    Point p = viewRect.getLocation();
                    int startIndex = ViewStreamDlg.this.text.viewToModel(p);
                    p.x += viewRect.width;
                    p.y += viewRect.height;
                    try {
                        endIndex = ViewStreamDlg.this.text.getLineOfOffset(ViewStreamDlg.this.text.viewToModel(p));
                    }
                    catch (BadLocationException ble) {
                        endIndex = 0;
                    }
                }
                if ((double)endIndex + 1.2 > (double)ViewStreamDlg.this.currentView) {
                    ViewStreamDlg.this.currentView = (int)((double)endIndex * 1.2) + 20;
                    ViewStreamDlg.this.fillBuffer();
                    ViewStreamDlg.this.pane.getVerticalScrollBar().getModel().setValue(e.getValue());
                }
            }
        });
        DefaultCaret caret = (DefaultCaret)this.text.getCaret();
        caret.setUpdatePolicy(1);
        mainPanel.add((Component)this.pane, "Center");
        mainPanel.add((Component)new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewStreamDlg.this.setVisible(false);
            }
        }), "South");
        this.add(mainPanel);
    }

    @Override
    public void setVisible(boolean isShown) {
        if (isShown) {
            this.pack();
            this.currentView = (int)((double)this.text.getLineCount() * 1.2) + 20;
            this.fillBuffer();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(1000L);
                                ViewStreamDlg.this.fillBuffer();
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            };
            this.t = new Thread(r);
            this.t.start();
        } else {
            if (this.t != null && this.t.isAlive()) {
                this.t.stop();
            }
            this.close();
        }
        super.setVisible(isShown);
    }

    public String next() {
        try {
            String s = this.reader.readLine();
            if (s != null) {
                ++this.currentRead;
            }
            return s;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public void fillBuffer() {
        String s = null;
        while (this.currentRead < this.currentView && (s = this.next()) != null) {
            this.text.append(s + "\n");
        }
    }

    private void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

