/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.gui.CancelableWorkerDlg;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.server.client.Controller;
import jams.server.client.JAMSWorkspaceUploader;
import jams.server.client.error.DefaultFileUploadErrorHandling;
import jams.tools.LogTools;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class UploadWorkspaceDlg
extends JDialog {
    JTextField wsName = new JTextField();
    JLabel wsNameLabel = new JLabel("Name of workspace ");
    JTextField wsPath = new JTextField();
    JLabel wsPathLabel = new JLabel("Path to workspace ");
    JButton chooseWorkspace = new JButton("Choose");
    JTextField compLibPath = new JTextField();
    JLabel compLibPathLabel = new JLabel("Path to components library ");
    JButton chooseCompLib = new JButton("Choose");
    JTextField rtLibPath = new JTextField();
    JLabel uiLibPathLabel = new JLabel("Path to executable library ");
    JButton chooseUiLib = new JButton("Choose");
    JButton uploadButton = new JButton("Upload");
    JButton cancelButton = new JButton("Cancel");
    boolean uiOk = false;
    boolean libOk = false;
    boolean wsOk = false;
    JFileChooser jfc = new JFileChooser();
    Controller controller = null;
    JPanel mainPanel = new JPanel();
    LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(Controller.class.getName())});
    boolean uploadSuccessful = false;

    public UploadWorkspaceDlg(Window w, Controller controller) {
        super(w, "Upload Workspace");
        this.controller = controller;
        this.add(this.getPanel());
        this.pack();
        this.setResizable(false);
    }

    public UploadWorkspaceDlg(Frame w, Controller controller) {
        super(w, "Upload Workspace");
        this.controller = controller;
        this.add(this.getPanel());
        this.pack();
        this.setResizable(false);
    }

    public UploadWorkspaceDlg(Dialog w, Controller controller) {
        super(w, "Upload Workspace");
        this.controller = controller;
        this.add(this.getPanel());
        this.pack();
        this.setResizable(false);
    }

    private JPanel getPanel() {
        GroupLayout mainLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainLayout);
        Box bottom = new Box(0);
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.uploadButton);
        bottom.add(this.cancelButton);
        bottom.add(Box.createHorizontalGlue());
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup().addGroup(mainLayout.createSequentialGroup().addComponent(this.wsNameLabel, 100, 200, 500).addContainerGap().addComponent(this.wsName, 200, 200, 200)).addGroup(mainLayout.createSequentialGroup().addComponent(this.wsPathLabel, 100, 200, 500).addContainerGap().addComponent(this.wsPath, 200, 200, 200).addContainerGap().addComponent(this.chooseWorkspace)).addGroup(mainLayout.createSequentialGroup().addComponent(this.compLibPathLabel, 100, 200, 500).addContainerGap().addComponent(this.compLibPath, 200, 200, 200).addContainerGap().addComponent(this.chooseCompLib)).addGroup(mainLayout.createSequentialGroup().addComponent(this.uiLibPathLabel, 100, 200, 500).addContainerGap().addComponent(this.rtLibPath, 200, 200, 200).addContainerGap().addComponent(this.chooseUiLib)).addComponent(bottom));
        mainLayout.setVerticalGroup(mainLayout.createSequentialGroup().addGap(5, 10, 10).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.wsNameLabel, 25, 25, 25).addComponent(this.wsName, 25, 25, 25)).addGap(5, 10, 10).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.wsPathLabel, 25, 25, 25).addComponent(this.wsPath, 25, 25, 25).addComponent(this.chooseWorkspace, 25, 25, 25)).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.compLibPathLabel, 25, 25, 25).addComponent(this.compLibPath, 25, 25, 25).addComponent(this.chooseCompLib, 25, 25, 25)).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.uiLibPathLabel, 25, 25, 25).addComponent(this.rtLibPath, 25, 25, 25).addComponent(this.chooseUiLib, 25, 25, 25)).addGap(20, 20, 20).addComponent(bottom));
        this.chooseWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadWorkspaceDlg.this.jfc.setFileSelectionMode(1);
                UploadWorkspaceDlg.this.jfc.setMultiSelectionEnabled(false);
                if (UploadWorkspaceDlg.this.jfc.showOpenDialog(UploadWorkspaceDlg.this.wsPath) == 0) {
                    File f = UploadWorkspaceDlg.this.jfc.getSelectedFile();
                    UploadWorkspaceDlg.this.wsPath.setText(f.getAbsolutePath());
                }
            }
        });
        this.chooseCompLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadWorkspaceDlg.this.jfc.setFileSelectionMode(1);
                UploadWorkspaceDlg.this.jfc.setFileFilter(null);
                UploadWorkspaceDlg.this.jfc.setMultiSelectionEnabled(false);
                if (UploadWorkspaceDlg.this.jfc.showOpenDialog(UploadWorkspaceDlg.this.wsPath) == 0) {
                    File f = UploadWorkspaceDlg.this.jfc.getSelectedFile();
                    UploadWorkspaceDlg.this.compLibPath.setText(f.getAbsolutePath());
                }
            }
        });
        this.chooseUiLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadWorkspaceDlg.this.jfc.setFileSelectionMode(0);
                UploadWorkspaceDlg.this.jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.isFile() && f.getName().endsWith(".jar");
                    }

                    @Override
                    public String getDescription() {
                        return "Java Archive (.jar)";
                    }
                });
                UploadWorkspaceDlg.this.jfc.setMultiSelectionEnabled(false);
                if (UploadWorkspaceDlg.this.jfc.showOpenDialog(UploadWorkspaceDlg.this.wsPath) == 0) {
                    File f = UploadWorkspaceDlg.this.jfc.getSelectedFile();
                    UploadWorkspaceDlg.this.rtLibPath.setText(f.getAbsolutePath());
                }
            }
        });
        this.rtLibPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.rtLibPath.getText());
                if (!(f.exists() && f.isFile() && f.getName().endsWith(".jar"))) {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.uiOk = false;
                } else {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.uiOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.rtLibPath.getText());
                if (!(f.exists() && f.isFile() && f.getName().endsWith(".jar"))) {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.uiOk = false;
                } else {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.uiOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.rtLibPath.getText());
                if (!(f.exists() && f.isFile() && f.getName().endsWith(".jar"))) {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.uiOk = false;
                } else {
                    UploadWorkspaceDlg.this.rtLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.uiOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }
        });
        this.compLibPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.compLibPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.libOk = false;
                } else {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.libOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.compLibPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.libOk = false;
                } else {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.libOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.compLibPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.libOk = false;
                } else {
                    UploadWorkspaceDlg.this.compLibPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.libOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }
        });
        this.wsPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.wsPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.wsOk = false;
                } else {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.wsOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.wsPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.wsOk = false;
                } else {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.wsOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                File f = new File(UploadWorkspaceDlg.this.wsPath.getText());
                if (!f.exists() || !f.isDirectory()) {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.red);
                    UploadWorkspaceDlg.this.wsOk = false;
                } else {
                    UploadWorkspaceDlg.this.wsPath.setBackground(Color.white);
                    UploadWorkspaceDlg.this.wsOk = true;
                }
                UploadWorkspaceDlg.this.uploadButton.setEnabled(UploadWorkspaceDlg.this.uiOk & UploadWorkspaceDlg.this.wsOk & UploadWorkspaceDlg.this.libOk);
            }
        });
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObserverWorkerDlg worker = null;
                Component c = SwingUtilities.getRoot(UploadWorkspaceDlg.this.mainPanel);
                worker = c instanceof Frame ? new ObserverWorkerDlg(new CancelableWorkerDlg(new WorkerDlg((Window)((Frame)c), "Uploading Workspace")).getWorkerDlg()) : new ObserverWorkerDlg(new CancelableWorkerDlg(new WorkerDlg((Window)((Frame)c), "Uploading Workspace")).getWorkerDlg());
                UploadWorkspaceDlg.this.observable.deleteObservers();
                UploadWorkspaceDlg.this.observable.addObserver((Observer)worker);
                worker.getWorkerDlg().setInderminate(true);
                worker.getWorkerDlg().setTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UploadWorkspaceDlg.this.uploadWorkspace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
                worker.getWorkerDlg().execute();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = SwingUtilities.getRoot(UploadWorkspaceDlg.this.mainPanel);
                if (c != null) {
                    c.setVisible(false);
                }
            }
        });
        return this.mainPanel;
    }

    private void uploadWorkspace() throws IOException {
        this.uploadSuccessful = false;
        if (!this.validateInput()) {
            JOptionPane.showMessageDialog(this.mainPanel, "Unable to upload workspace! Paths are incorrect!");
        }
        File workspaceDirectory = new File(this.wsPath.getText());
        File compLibFile = new File(this.compLibPath.getText());
        File rtLibFile = new File(this.rtLibPath.getText());
        String name = this.wsName.getText();
        JAMSWorkspace workspace = new JAMSWorkspace(workspaceDirectory, (JAMSRuntime)new StandardRuntime(null));
        JAMSWorkspaceUploader uploader = new JAMSWorkspaceUploader(this.controller);
        uploader.uploadWorkspace((Workspace)workspace, new File[]{compLibFile}, rtLibFile, "", new DefaultFileUploadErrorHandling());
        this.uploadSuccessful = true;
    }

    public boolean validateInput() {
        File workspaceFile = new File(this.wsPath.getText());
        File compLibFile = new File(this.compLibPath.getText());
        File uiLibFile = new File(this.rtLibPath.getText());
        if (!workspaceFile.exists() || !workspaceFile.isDirectory()) {
            return false;
        }
        if (!compLibFile.exists() || !compLibFile.isDirectory()) {
            return false;
        }
        return uiLibFile.exists() && uiLibFile.isFile();
    }

    boolean getUploadSuccessful() {
        return this.uploadSuccessful;
    }
}

