/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.server.client.Controller;
import jams.server.client.HTTPClient;
import jams.server.entities.User;
import jams.server.entities.Users;
import jams.tools.LogTools;
import java.util.logging.Level;

public class UserController {
    private final HTTPClient client;
    private final String urlStr;

    public UserController(Controller ctrl) {
        this.client = ctrl.getClient();
        this.urlStr = ctrl.getServerURL();
    }

    public Users findAll() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Retrieving_list_of_users"), (Object[])new Object[0]);
        return this.client.httpGet(this.urlStr + "/user/all", Users.class);
    }

    public Users findInRange(int from, int to) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Retrieving_list_of_users_from_{0}_to_{1}"), (Object[])new Object[]{from, to});
        return this.client.httpGet(this.urlStr + "/user/" + from + "/" + to, Users.class);
    }

    public User find(int id) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Retrieving_user_with_id_{0}"), (Object[])new Object[]{id});
        return this.client.httpGet(this.urlStr + "/user/" + id, User.class);
    }

    public User delete(int id) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Deleting_user_with_id_{0}"), (Object[])new Object[]{id});
        return this.client.httpPost(this.urlStr + "/user/" + id, "DELETE", null, User.class);
    }

    public User createUser(User user) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Creating_new_user"), (Object[])new Object[0]);
        return this.client.httpPost(this.urlStr + "/user/create", "PUT", user, User.class);
    }
}

