/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.server.client.Controller;
import jams.server.client.HTTPClient;
import jams.server.entities.Job;
import jams.server.entities.JobState;
import jams.server.entities.Jobs;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.FileTools;
import jams.tools.LogTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.ws.rs.ProcessingException;

public class JobController {
    private final Controller ctrl;
    private final HTTPClient client;
    private final String urlStr;

    public JobController(Controller ctrl) {
        this.ctrl = ctrl;
        this.client = ctrl.getClient();
        this.urlStr = ctrl.getServerURL();
    }

    public Job create(Workspace ws, WorkspaceFileAssociation wfa) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"creating_job_from_workspace_{0}_with_model_{1}"), (Object[])new Object[]{ws.getName(), wfa.getFileName()});
        return this.client.httpGet(this.urlStr + "/job/create?workspace=" + ws.getId() + "&file=" + wfa.getFile().getId(), Job.class);
    }

    public Jobs find() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_jobs_of_user"), (Object[])new Object[0]);
        return this.client.httpGet(this.urlStr + "/job/find", Jobs.class);
    }

    public Jobs findActive() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_active_jobs_of_user"), (Object[])new Object[0]);
        return this.client.httpGet(this.urlStr + "/job/findActive", Jobs.class);
    }

    public Jobs findAll() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_all_jobs"), (Object[])new Object[0]);
        if (this.ctrl.getUser().getAdmin() == 0) {
            throw new ProcessingException(JAMS.i18n((String)"operation_denied_since_user_is_not_an_admin"));
        }
        return this.client.httpGet(this.urlStr + "/job/findAll", Jobs.class);
    }

    public JobState getState(Job job) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"getting_the_state_of_job:{0}"), (Object[])new Object[]{job.getId()});
        return this.client.httpGet(this.urlStr + "/job/" + job.getId() + "/state", JobState.class);
    }

    public JobState kill(Job job) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"killing_the_job_with_id_{0}"), (Object[])new Object[]{job.getId()});
        return this.client.httpGet(this.urlStr + "/job/" + job.getId() + "/kill", JobState.class);
    }

    public Job delete(Job job) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"deleting_the_job_with_id_{0}"), (Object[])new Object[]{job.getId()});
        return this.client.httpGet(this.urlStr + "/job/" + job.getId() + "/delete", Job.class);
    }

    public void deleteAll() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"deleting_all_jobs"), (Object[])new Object[0]);
        this.client.httpGet(this.urlStr + "/job/reset", String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String infolog(Job job, int offset, int size) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_info_log_stream_of_job_{0}"), (Object[])new Object[]{job.getId()});
        InputStream is = this.client.getStream(this.urlStr + "/job/" + job.getId() + "/infolog");
        try {
            String string = FileTools.streamToString((InputStream)is, (int)offset, (int)size);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                LogTools.log(this.getClass(), (Level)Level.WARNING, (Throwable)ioe, (String)ioe.toString(), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String errorlog(Job job, int offset, int size) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_error_log_stream_of_job_{0}"), (Object[])new Object[]{job.getId()});
        InputStream is = this.client.getStream(this.urlStr + "/job/" + job.getId() + "/errorlog");
        try {
            String string = FileTools.streamToString((InputStream)is, (int)offset, (int)size);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                LogTools.log(this.getClass(), (Level)Level.WARNING, (Throwable)ioe, (String)ioe.toString(), (Object[])new Object[0]);
            }
        }
    }

    public File download(File target, Job job) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"downloading_workspace_of_job_{0}"), (Object[])new Object[]{job.getId()});
        Workspace ws = this.client.httpGet(this.urlStr + "/job/" + job.getId() + "/refresh/", Workspace.class);
        return this.ctrl.workspaces().downloadWorkspace(target, ws);
    }
}

