/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.tools.FileTools;
import jams.tools.LogTools;
import jams.tools.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class HTTPClient {
    private String sessionID = null;

    public HTTPClient() {
        Logger.getLogger(this.getClass().getName()).setLevel(Level.ALL);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public <T> T connect(String urlStr, Class<T> responseType) {
        LogTools.log(this.getClass(), (Level)Level.FINER, (String)JAMS.i18n((String)"LOGIN_TO_{1}"), (Object[])new Object[]{urlStr});
        this.sessionID = null;
        return this.httpRequest(urlStr, "GET", null, responseType);
    }

    public void disconnect() {
        LogTools.log(this.getClass(), (Level)Level.FINER, (String)JAMS.i18n((String)"DISCONNECT"), (Object[])new Object[0]);
        this.sessionID = null;
    }

    public <T> T httpGet(String urlStr, Class<T> responseType) {
        return this.httpRequest(urlStr, "GET", null, responseType);
    }

    public <T> T httpPost(String urlStr, String method, Object obj, Class<T> responseType) {
        return this.httpRequest(urlStr, method, obj, responseType);
    }

    private <T> T httpFileUpload(String urlStr, MultiPart multipart, Class<T> responseType) {
        Client client = ClientBuilder.newClient();
        if (!client.getConfiguration().isRegistered(MultiPartFeature.class)) {
            client.register(MultiPartFeature.class);
        }
        Response response = null;
        try {
            response = client.target(urlStr).request().header("Cookie", (Object)("JSESSIONID=" + URLEncoder.encode(this.sessionID == null ? "0" : this.sessionID, "UTF-8"))).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessingException((Throwable)uee);
        }
        if (response == null) {
            throw new ProcessingException(StringTools.format((String)JAMS.i18n((String)"There_was_no_response_from_{0}"), (Object[])new Object[]{urlStr}));
        }
        try {
            if (response.getStatus() >= 400) {
                throw new ResponseProcessingException(response, "Request failed!");
            }
            if (response.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                Object uee = response.readEntity(responseType);
                return (T)uee;
            }
            if (response.getMediaType().equals((Object)MediaType.TEXT_HTML_TYPE)) {
                String msg = (String)response.readEntity(String.class);
                throw new ResponseProcessingException(response, StringTools.format((String)JAMS.i18n((String)"The_response_from_{0}_was_a_text_message_with_the_content_{1}"), (Object[])new Object[]{urlStr, msg}));
            }
            throw new ResponseProcessingException(response, StringTools.format((String)JAMS.i18n((String)"The_response_from_{0}_was_a_message_with_not_supported_mediatype_{1}"), (Object[])new Object[]{urlStr, response.getMediaType()}));
        }
        finally {
            response.close();
            client.close();
        }
    }

    public <T> T httpFileUpload(String urlStr, File f, Class<T> responseType) {
        if (!f.exists() || f.isDirectory()) {
            throw new ProcessingException(StringTools.format((String)JAMS.i18n((String)"{0}_cannot_be_uploaded,_since_it_is_either_not_existing_or_a_directory"), (Object[])new Object[]{f.toString()}));
        }
        FileDataBodyPart filePart = new FileDataBodyPart("file", f);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)filePart);
        return this.httpFileUpload(urlStr, multipart, responseType);
    }

    public <T> T httpFileUpload(String urlStr, InputStream in, Class<T> responseType) throws IOException {
        StreamDataBodyPart filePart = new StreamDataBodyPart("file", in);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)filePart);
        return this.httpFileUpload(urlStr, multipart, responseType);
    }

    public File download(String urlStr, File location) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(urlStr);
        try {
            get.addHeader((Header)new BasicHeader("Cookie", "JSESSIONID=" + URLEncoder.encode(this.sessionID == null ? "0" : this.sessionID, "UTF-8")));
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessingException((Throwable)uee);
        }
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
        if (httpResponse.getStatusLine().getStatusCode() >= 400) {
            throw new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), urlStr);
        }
        try (InputStream is = httpResponse.getEntity().getContent();){
            Header[] name = httpResponse.getHeaders("fileName");
            FileTools.assertDirectory((String)location.getAbsolutePath());
            location = name.length > 0 && name[0].getValue() != null ? new File(location, new File(name[0].getValue()).getName()) : new File(location, "unnamed");
            if (location.getParentFile() != null) {
                FileTools.assertDirectory((String)location.getParentFile().getAbsolutePath());
            }
            FileTools.streamToFile((File)location, (InputStream)is);
        }
        return location;
    }

    public InputStream getStream(String urlStr) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(urlStr);
        try {
            get.addHeader((Header)new BasicHeader("Cookie", "JSESSIONID=" + URLEncoder.encode(this.sessionID == null ? "0" : this.sessionID, "UTF-8")));
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessingException((Throwable)uee);
        }
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
        if (httpResponse.getStatusLine().getStatusCode() >= 400) {
            throw new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), urlStr);
        }
        return httpResponse.getEntity().getContent();
    }

    protected <T> T httpRequest(String urlStr, String requestMethod, Object param, Class<T> responseType) {
        Object result;
        Response response;
        Client client = ClientBuilder.newClient();
        LogTools.log(this.getClass(), (Level)Level.FINER, (String)JAMS.i18n((String)"SENDING_{0}-REQUEST_TO_{1}"), (Object[])new Object[]{requestMethod, urlStr});
        try {
            response = requestMethod.compareTo("GET") != 0 ? client.target(urlStr).request().header("Access-Control-Request-Method", (Object)requestMethod).header("Cookie", (Object)("JSESSIONID=" + URLEncoder.encode(this.sessionID == null ? "0" : this.sessionID, "UTF-8"))).method(requestMethod, Entity.entity((Object)param, (String)"application/xml")) : client.target(urlStr).request().header("Access-Control-Request-Method", (Object)requestMethod).header("Cookie", (Object)("JSESSIONID=" + URLEncoder.encode(this.sessionID == null ? "0" : this.sessionID, "UTF-8"))).get();
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessingException((Throwable)uee);
        }
        if (response == null) {
            throw new ProcessingException(StringTools.format((String)JAMS.i18n((String)"There_was_no_response_from_{0}"), (Object[])new Object[]{urlStr}));
        }
        if (response.getStatus() >= 400) {
            throw new ResponseProcessingException(response, "Request failed");
        }
        if (this.sessionID == null) {
            if (response.getHeaders() == null || response.getHeaders().get((Object)"set-cookie") == null) {
                String msg = null;
                try {
                    msg = (String)response.readEntity(String.class);
                }
                catch (Throwable t) {
                    throw new ProcessingException(JAMS.i18n((String)"Unable to receive any session id!"), t);
                }
                throw new ProcessingException(msg);
            }
            result = ((List)response.getHeaders().get((Object)"set-cookie")).toString();
            result = ((String)result).split(";")[0];
            this.sessionID = ((String)result).split("=")[1];
        }
        try {
            if (response.getMediaType() == null) {
                // empty if block
            }
            if (response.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                LogTools.log(this.getClass(), (Level)Level.FINER, (String)JAMS.i18n((String)"Request_send_successful!"), (Object[])new Object[0]);
                result = response.readEntity(responseType);
                return (T)result;
            }
            if (response.getMediaType().equals((Object)MediaType.TEXT_HTML_TYPE)) {
                String msg = (String)response.readEntity(String.class);
                throw new ProcessingException(StringTools.format((String)JAMS.i18n((String)"The_response_from_{0}_was_a_text_message_with_the_content_{1}"), (Object[])new Object[]{urlStr, msg}));
            }
            throw new ProcessingException(StringTools.format((String)JAMS.i18n((String)"The_response_from_{0}_was_a_message_with_not_supported_mediatype_{1}"), (Object[])new Object[]{urlStr, response.getMediaType()}));
        }
        finally {
            response.close();
            client.close();
        }
    }
}

