/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.data.ArrayDataSupplier;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.server.client.FileController;
import jams.server.client.HTTPClient;
import jams.server.client.JAMSWorkspaceUploader;
import jams.server.client.JobController;
import jams.server.client.UserController;
import jams.server.client.WorkspaceController;
import jams.server.client.error.ErrorHandler;
import jams.server.entities.Job;
import jams.server.entities.User;
import jams.server.entities.Users;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.LogTools;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;

public class Controller {
    private final String SEPARATOR = "***************************************************\n";
    private final HTTPClient client = new HTTPClient();
    private User user;
    private final String urlStr;
    public final String VERSION = "0.1.0.1";

    public Controller(String urlStr, String userName, String password) {
        Logger.getLogger(Controller.class.getName()).setLevel(Level.ALL);
        this.urlStr = urlStr;
        this.connect(userName, password);
    }

    private void connect(String userName, String password) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)"{0}{1} {2}", (Object[])new Object[]{"***************************************************\n", JAMS.i18n((String)"Trying_to_connect_with"), this.urlStr});
        String serverVersion = this.client.httpGet(this.urlStr + "/version", String.class);
        if (!this.isCompatibleWithServer(serverVersion)) {
            throw new ProcessingException(JAMS.i18n((String)"Client (Version: %1 is not compatible with Server (Version: %2").replace("%1", "0.1.0.1").replace("%2", serverVersion));
        }
        this.user = this.client.connect(this.urlStr + "/user/login?login=" + userName + "&password=" + password, User.class);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)"{0}\n", (Object[])new Object[]{JAMS.i18n((String)"Login_successful")});
    }

    public boolean isCompatibleWithServer(String serverVersion) {
        return "0.1.0.1".compareTo(serverVersion) == 0;
    }

    public void close() {
        this.client.disconnect();
    }

    public boolean isConnected() {
        try {
            String b = this.client.httpGet(this.urlStr + "/user/isConnected", String.class);
            return Boolean.parseBoolean(b.toString());
        }
        catch (NumberFormatException ioe) {
            LogTools.log(this.getClass(), (Level)Level.WARNING, (String)ioe.toString(), (Object[])new Object[]{ioe});
            return false;
        }
    }

    public void cleanUp() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)"{0}{1}", (Object[])new Object[]{"***************************************************\n", JAMS.i18n((String)"Clean_up_JAMSCloud")});
        this.client.httpGet(this.urlStr + "/file/clean", String.class);
    }

    public double getLoad() {
        try {
            String b = this.client.httpGet(this.urlStr + "/job/load", String.class);
            return Double.parseDouble(b);
        }
        catch (NumberFormatException | ProcessingException nfe) {
            LogTools.log(this.getClass(), (Level)Level.WARNING, (String)nfe.toString(), (Object[])new Object[]{nfe});
            return Double.NaN;
        }
    }

    public String getServerURL() {
        return this.urlStr;
    }

    public HTTPClient getClient() {
        return this.client;
    }

    public User getUser() {
        return this.user;
    }

    public FileController files() {
        return new FileController(this);
    }

    public WorkspaceController workspaces() {
        return new WorkspaceController(this);
    }

    public UserController users() {
        return new UserController(this);
    }

    public JobController jobs() {
        return new JobController(this);
    }

    public static void main(String[] args) throws IOException {
        Controller client = new Controller("http://data.geogr.uni-jena.de:8080/jamscloud/webresources", "secret", "secret");
        User user = new User(Integer.valueOf(23), "santosh2", "snepal");
        user.setEmail("santosh3nepal@gmail.com");
        user.setName("Santosh Nepal");
        user.setAdmin(Integer.valueOf(0));
        client.users().createUser(user);
        user = new User(Integer.valueOf(24), "subodh", "skamal");
        user.setEmail("asu.patience@gmail.com");
        user.setName("Subodh Kamal");
        user.setAdmin(Integer.valueOf(0));
        client.users().createUser(user);
    }

    public static void main2(String[] args) throws IOException {
        jams.server.entities.File f1;
        Users result;
        Users users;
        Controller client = new Controller("http://kirk.geogr.uni-jena.de:8080/jams-cloud-server/webresources", "secret", "secret");
        User user = new User(Integer.valueOf(5));
        user.setAdmin(Integer.valueOf(1));
        user.setEmail("blubb@gmx.de");
        user.setId(Integer.valueOf(5));
        user.setLogin(Integer.toString(new Random().nextInt()));
        user.setName("Der Marshmellow Mann");
        user.setPassword("test");
        User newUser = client.users().createUser(user);
        if (newUser != null) {
            System.out.println("User was created successfully with id " + newUser.getId());
            newUser = client.users().delete(newUser.getId());
            if (newUser != null) {
                System.out.println("User was successfully deleted");
            }
        }
        if ((users = client.users().findAll()) != null) {
            System.out.println("List of all users is now:" + users.toString());
        }
        if ((result = client.users().findInRange(0, 1)) != null) {
            System.out.println("Users with id 0 and 1 are" + result.toString());
        }
        if ((f1 = client.files().uploadFile(new File("E:/tmp/style.css"))) != null) {
            System.out.println("File with id " + f1.getId() + " was uploaded successfully!");
        }
        File f2 = new File("E:/tmp/show_log.php");
        File f3 = new File("E:/tmp/successful.php");
        Map<File, jams.server.entities.File> map = null;
        try {
            map = client.files().uploadFile((Iterable<File>)new ArrayDataSupplier((Object[])new File[]{f2, f3}), new ErrorHandler<File>(){

                @Override
                public boolean handleError(File o, Throwable ex) {
                    System.out.println("Unable to upload " + o);
                    return true;
                }
            });
        }
        catch (IOException ioe) {
            System.out.println("File with ids " + ((jams.server.entities.File)map.get(f2)).getId() + "/" + ((jams.server.entities.File)map.get(f3)).getId() + " were uploaded successfully!");
        }
        jams.server.entities.Workspace ws = new jams.server.entities.Workspace();
        ws.setId(Integer.valueOf(0));
        ws.setName("TestWs");
        ws.setCreationDate(new Date());
        ws = client.workspaces().create(ws);
        if (ws != null) {
            System.out.println("Workspace with id " + ws.getId() + " was created successfully!");
            client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, f1, 4, "/test/test1.dat"));
            client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, map.get(f2), 4, "/test/test2.dat"));
            client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, map.get(f3), 4, "/test/test3.dat"));
            ws = client.workspaces().delete(ws);
            if (ws != null) {
                System.out.println("Workspace with id " + ws.getId() + " was removed successfully!");
            }
        }
        JAMSWorkspaceUploader uploader = new JAMSWorkspaceUploader(client);
        JAMSWorkspace workspace = new JAMSWorkspace(new File("E:\\ModelData\\JAMS-Gehlberg"), (JAMSRuntime)new StandardRuntime(null));
        jams.server.entities.Workspace ws2 = uploader.uploadWorkspace((Workspace)workspace, new File[]{new File("E:\\JAMS_rep\\JAMS\\lib")}, new File("E:\\JAMS_rep\\JAMS\\nbprojects\\jams-ui\\dist\\jams-ui.jar"), "", new ErrorHandler<File>(){

            @Override
            public boolean handleError(File o, Throwable ex) {
                System.out.println("Unable to upload " + o);
                return true;
            }
        });
        if (ws2 != null) {
            Job job;
            System.out.println("Number of files: " + ws2.getFiles().size());
            System.out.println("Workspace of Wilde Gera Model was uploaded successfully with id " + ws2.getId());
            client.workspaces().downloadWorkspace(new File("E:/test_client/" + ws2.getId() + "/"), ws2);
            System.out.println("Workspace of Wilde Gera Model was downloaded to E:/test_client/" + ws2.getId());
            WorkspaceFileAssociation wfaModel = null;
            for (WorkspaceFileAssociation f : ws2.getFiles()) {
                if (!f.getPath().endsWith("j2k_gehlberg.jam")) continue;
                wfaModel = f;
                break;
            }
            if ((job = client.jobs().create(ws2, wfaModel)) != null) {
                System.out.println("Wilde Gera Model started successfully! Job Id is: " + job.getId());
            }
            while (client.jobs().getState(job).isActive()) {
                System.out.println("Job with id " + job.getId() + " still running!");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Job with id " + job.getId() + " finished after " + client.jobs().getState(job).getDuration() + " ms.");
            jams.server.entities.Workspace ws3 = job.getWorkspace();
            System.out.println("Workspace of " + ws3.getName() + " Model is downloading!");
            client.jobs().download(new File("E:/test_client/" + ws3.getName()), job);
            client.jobs().delete(job);
            System.out.println("Job with id " + job.getId() + " deleted");
            client.workspaces().delete(ws2);
            System.out.println("Workspace of Wilde Gera Model was deleted!");
        }
        client.close();
    }

    public static void main3(String[] args) throws IOException {
        Controller client = new Controller("http://localhost:8080/jams-cloud-server/webresources", "admin", "jamscloud");
        JAMSWorkspaceUploader uploader = new JAMSWorkspaceUploader(client);
        JAMSWorkspace workspace = new JAMSWorkspace(new File("d:\\jamsapplication\\JAMS-Gehlberg"), (JAMSRuntime)new StandardRuntime((SystemProperties)JAMSProperties.createProperties()));
        jams.server.entities.Workspace ws2 = uploader.uploadWorkspace((Workspace)workspace, new File[]{new File("D:\\jams\\jams-bin\\components"), new File("D:\\jamsmodels\\nbprojects\\components")}, new File("d:\\jams\\jams-bin\\jams-headless.jar"), "", new ErrorHandler<File>(){

            @Override
            public boolean handleError(File o, Throwable ex) {
                System.out.println("Unable to upload " + o);
                return true;
            }
        });
        if (ws2 != null) {
            Job job;
            System.out.println("Number of files: " + ws2.getFiles().size());
            System.out.println("Workspace of Wilde Gera Model was uploaded successfully with id " + ws2.getId());
            client.workspaces().downloadWorkspace(new File("E:/test_client/" + ws2.getId() + "/"), ws2);
            System.out.println("Workspace of Wilde Gera Model was downloaded to E:/test_client/" + ws2.getId());
            WorkspaceFileAssociation wfaModel = null;
            for (WorkspaceFileAssociation f : ws2.getFiles()) {
                if (!f.getPath().endsWith("j2k_gehlberg.jam")) continue;
                wfaModel = f;
                break;
            }
            if ((job = client.jobs().create(ws2, wfaModel)) != null) {
                System.out.println("Wilde Gera Model started successfully! Job Id is: " + job.getId());
            }
            while (client.jobs().getState(job).isActive()) {
                System.out.println("Job with id " + job.getId() + " still running!");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Job with id " + job.getId() + " finished after " + client.jobs().getState(job).getDuration() + " ms.");
            jams.server.entities.Workspace ws3 = job.getWorkspace();
            System.out.println("Workspace of " + ws3.getName() + " Model is downloading!");
            client.jobs().download(new File("E:/test_client/" + ws3.getName()), job);
            client.jobs().delete(job);
            System.out.println("Job with id " + job.getId() + " deleted");
            client.workspaces().delete(ws2);
            System.out.println("Workspace of Wilde Gera Model was deleted!");
        }
        client.close();
    }
}

