/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.FeatureImplUtils;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.resources.Classes;
import org.geotools.resources.Utilities;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeImpl
extends AttributeTypeImpl
implements ComplexType {
    protected Map<Name, PropertyDescriptor> propertyMap = null;

    public ComplexTypeImpl(Name name, Collection<PropertyDescriptor> properties, boolean identified, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, Collection.class, identified, isAbstract, restrictions, superType, description);
        if (properties == null) {
            this.propertyMap = Collections.emptyMap();
        } else {
            this.propertyMap = new HashMap<Name, PropertyDescriptor>();
            for (PropertyDescriptor pd : properties) {
                this.propertyMap.put(pd.getName(), pd);
            }
        }
    }

    public Class<Collection<Property>> getBinding() {
        return super.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        return FeatureImplUtils.unmodifiable(this.propertyMap.values());
    }

    public PropertyDescriptor getDescriptor(Name name) {
        return this.propertyMap.get(name);
    }

    public PropertyDescriptor getDescriptor(String name) {
        return this.getDescriptor(new NameImpl(name));
    }

    public boolean isInline() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplexTypeImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComplexTypeImpl other = (ComplexTypeImpl)o;
        return Utilities.equals(this.propertyMap, other.propertyMap);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * ((Object)this.propertyMap).hashCode();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName((Object)this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.isIdentified()) {
            sb.append(" identified");
        }
        if (this.superType != null) {
            sb.append(" extends ");
            sb.append(this.superType.getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        boolean first = true;
        for (PropertyDescriptor property : this.getDescriptors()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(property.getName().getLocalPart());
            sb.append(":");
            sb.append(property.getType().getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        if (this.description != null) {
            sb.append("\n\tdescription=");
            sb.append((CharSequence)this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            sb.append("\nrestrictions=");
            first = true;
            for (Filter filter : this.restrictions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(filter);
            }
        }
        return sb.toString();
    }
}

