/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.store.MaxFeaturesFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureSource2
implements FeatureSource<SimpleFeatureType, SimpleFeature> {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    protected ActiveTypeEntry entry;

    public AbstractFeatureSource2(ActiveTypeEntry entry) {
        this.entry = entry;
    }

    public DataStore getDataStore() {
        return this.entry.parent;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.entry.listenerManager.addFeatureListener(this, listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.entry.listenerManager.removeFeatureListener(this, listener);
    }

    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException {
        SimpleFeatureType featureType = this.entry.getFeatureType();
        Filter filter = query.getFilter();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        String[] propertyNames = query.getPropertyNames();
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(featureType);
        }
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.getFeatures(filter);
        if (propertyNames != null || query.getCoordinateSystem() != null) {
            try {
                SimpleFeatureType target = DataUtilities.createSubType(featureType, propertyNames, query.getCoordinateSystem());
                if (!featureType.equals(target)) {
                    LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
                    features = new ReTypingFeatureCollection(features, target);
                }
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", e);
            }
        }
        if (query.getCoordinateSystemReproject() != null) {
            features = query.getCoordinateSystem() != null ? this.reproject(features, query.getCoordinateSystem(), query.getCoordinateSystemReproject()) : new ReprojectingFeatureCollection(features, query.getCoordinateSystemReproject());
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            features = new MaxFeaturesFeatureCollection<SimpleFeatureType, SimpleFeature>(features, query.getMaxFeatures());
        }
        return features;
    }

    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Filter filter) throws IOException {
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            return new FilteringFeatureCollection<SimpleFeatureType, SimpleFeature>(this.getFeatures(), filter);
        }
        return this.getFeatures();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.entry.getFeatureType();
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.getFeatures().getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    protected FeatureCollection<SimpleFeatureType, SimpleFeature> reproject(FeatureCollection<SimpleFeatureType, SimpleFeature> features, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return new ReprojectingFeatureCollection(features, source, target);
    }

    @Override
    public Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }
}

