/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.AttributeReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIDFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    private final FIDReader fidReader;
    protected final Object[] attributes;
    private SimpleFeatureBuilder builder;

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader, SimpleFeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        this.fidReader = fidReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
        this.builder = new SimpleFeatureBuilder(schema);
    }

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader) throws SchemaException {
        this(attributeReader, fidReader, null);
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.attributeReader.hasNext()) {
            this.attributeReader.next();
            return this.readFeature(this.attributeReader);
        }
        throw new NoSuchElementException("There are no more Features to be read");
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("xxx");
        int ii = this.attributeReader.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            b.add(this.attributeReader.getAttributeType(i));
        }
        return b.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        String fid = this.fidReader.next();
        this.builder.reset();
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.builder.add(atts.read(i));
        }
        return this.builder.buildFeature(fid);
    }

    @Override
    public void close() throws IOException {
        this.fidReader.close();
        this.attributeReader.close();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.attributeReader.hasNext();
    }
}

