/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui;

import java.awt.GridLayout;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class SummaryStatisticsPanel
extends JPanel {
    private SummaryStatistics statistics = new SummaryStatistics();
    private JLabel[] statisticLabels;

    public SummaryStatisticsPanel() {
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new GridLayout(0, 2, 1, 1));
        this.setBorder(new TitledBorder("Classification Statistics"));
        this.statisticLabels = new JLabel[14];
        for (int i = 0; i < this.statisticLabels.length; ++i) {
            this.statisticLabels[i] = new JLabel();
            if (i % 2 != 1) continue;
            this.statisticLabels[i].setHorizontalAlignment(4);
        }
        this.statisticLabels[0].setText("count:");
        this.statisticLabels[2].setText("minimum:");
        this.statisticLabels[4].setText("maximum:");
        this.statisticLabels[6].setText("sum:");
        this.statisticLabels[8].setText("mean:");
        this.statisticLabels[10].setText("std. deviation:");
        this.statisticLabels[12].setText("variance:");
        for (JLabel statisticLabel : this.statisticLabels) {
            this.add(statisticLabel);
        }
    }

    public void calculateStatistics(double[] values, SummaryStatistics statistics) {
        this.statistics = statistics;
        this.updateLabels();
    }

    private void updateLabels() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(3);
        this.statisticLabels[1].setText(nf.format(this.statistics.getN()));
        this.statisticLabels[3].setText(nf.format(this.statistics.getMin()));
        this.statisticLabels[5].setText(nf.format(this.statistics.getMax()));
        this.statisticLabels[7].setText(nf.format(this.statistics.getSum()));
        this.statisticLabels[9].setText(nf.format(this.statistics.getMean()));
        this.statisticLabels[11].setText(nf.format(this.statistics.getStandardDeviation()));
        this.statisticLabels[13].setText(nf.format(this.statistics.getVariance()));
    }

    public StatisticalSummary getStatistics() {
        return this.statistics;
    }
}

