/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui;

import jams.worldwind.ui.ColorRamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColorRampPanel
extends JPanel {
    private final JButton startColorButton;
    private final JButton endColorButton;
    private Color startColor;
    private Color endColor;
    private final JColorChooser colorChooser = new JColorChooser();
    private JDialog dialog;
    private final ColorPanel colorPanel;
    private ColorRamp colorRamp = null;
    private int numberOfColors;
    private final String startColorAction = "Start Color";
    private final String endColorAction = "End Color";

    public ColorRampPanel() {
        this.startColorButton = new JButton("Start Color");
        this.startColorButton.setActionCommand("Start Color");
        this.startColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorRampPanel.this.buttonActionListener(e);
            }
        });
        this.startColor = Color.WHITE;
        this.startColorButton.setBackground(this.startColor);
        this.startColorButton.setEnabled(false);
        this.endColorButton = new JButton("End Color");
        this.endColorButton.setActionCommand("End Color");
        this.endColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorRampPanel.this.buttonActionListener(e);
            }
        });
        this.endColor = Color.BLUE;
        this.endColorButton.setBackground(this.endColor);
        this.endColorButton.setEnabled(false);
        this.colorPanel = new ColorPanel();
        this.setOpaque(true);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.addComponent(this, gbl, this.startColorButton, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this, gbl, this.endColorButton, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this, gbl, this.colorPanel, 0, 1, 2, 1, 1.0, 0.0);
    }

    public void setColorRamp(ColorRamp colorRamp) {
        this.colorRamp = colorRamp;
        this.numberOfColors = colorRamp.getSteps() - 1;
        this.colorPanel.repaint();
    }

    public void setNumberOfColors(int numberOfColors) {
        this.numberOfColors = numberOfColors;
        this.setButtonsEnabled(true);
    }

    public void setButtonsEnabled(boolean enabled) {
        this.startColorButton.setEnabled(enabled);
        this.endColorButton.setEnabled(enabled);
        if (!enabled) {
            this.colorPanel.setBackground(this.getBackground());
        }
    }

    public ColorRamp getColorRamp() {
        return this.colorRamp;
    }

    private void addComponent(Container container, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        container.add(c);
    }

    private void buttonActionListener(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "Start Color": {
                this.startColor = JColorChooser.showDialog(this, "Pick a Color", this.startColor);
                this.startColorButton.setBackground(this.startColor);
                break;
            }
            case "End Color": {
                this.endColor = JColorChooser.showDialog(this, "Pick a Color", this.endColor);
                this.endColorButton.setBackground(this.endColor);
            }
        }
        if (this.startColor != null && this.endColor != null) {
            this.colorPanel.repaint();
        }
    }

    private class ColorPanel
    extends JPanel {
        private ColorPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (ColorRampPanel.this.numberOfColors > 0 && ColorRampPanel.this.startColor != null && ColorRampPanel.this.endColor != null) {
                ColorRampPanel.this.colorRamp = new ColorRamp(ColorRampPanel.this.startColor, ColorRampPanel.this.endColor, ColorRampPanel.this.numberOfColors);
                int xsteps = this.getWidth() / ColorRampPanel.this.colorRamp.getSteps();
                int startx = 0;
                for (int i = 0; i < ColorRampPanel.this.colorRamp.getSteps(); ++i) {
                    g.setColor(ColorRampPanel.this.colorRamp.getColorRamp().get(i));
                    g.fillRect(startx, 0, xsteps, ColorRampPanel.this.colorPanel.getHeight());
                    g.setColor(Color.black);
                    g.drawLine(startx, 0, startx, ColorRampPanel.this.colorPanel.getHeight());
                    startx += xsteps;
                }
            }
        }
    }
}

