/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.data.shapefile;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.util.ShapefileLoader;
import jams.worldwind.data.shapefile.JamsShapeAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamsShapefileLoader
extends ShapefileLoader {
    private static final Logger logger = LoggerFactory.getLogger(JamsShapefileLoader.class);

    public JamsShapefileLoader() {
        this.setNumPolygonsPerLayer(1000000);
    }

    protected void addRenderablesForPolylines(Shapefile shp, RenderableLayer layer) {
        while (shp.hasNext()) {
            ShapefileRecord record = shp.nextRecord();
            if (!Shapefile.isPolylineType((String)record.getShapeType())) continue;
            ShapeAttributes attrs = this.createPolylineAttributes(record);
            layer.addRenderable(this.createPolyline(record, attrs));
        }
    }

    protected PointPlacemarkAttributes createPointAttributes(ShapefileRecord record) {
        logger.error("Shapefile point type NOT implemented - no attributes added!");
        return null;
    }

    protected ShapeAttributes createPolylineAttributes(ShapefileRecord record) {
        JamsShapeAttributes shapeAttributes = new JamsShapeAttributes(record);
        return shapeAttributes;
    }

    protected ShapeAttributes createPolygonAttributes(ShapefileRecord record) {
        JamsShapeAttributes shapeAttributes = new JamsShapeAttributes(record);
        shapeAttributes.setOutlineOpacity(0.2);
        shapeAttributes.setOutlineWidth(0.4);
        return shapeAttributes;
    }
}

