/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl.kernels;

import java.util.HashMap;
import java.util.Map;
import org.encog.engine.EncogEngineError;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.ResourceLoader;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncogKernel {
    private String cl;
    private final cl_context context;
    private cl_program program;
    private cl_kernel kernel;
    private final EncogCLDevice device;
    private final String sourceName;
    private int localWork;
    private int globalWork;
    private final String kernelName;

    public EncogKernel(EncogCLDevice encogCLDevice, String string, String string2) {
        this.sourceName = string;
        this.context = encogCLDevice.getPlatform().getContext();
        this.device = encogCLDevice;
        this.kernelName = string2;
        this.cl = ResourceLoader.loadString(string);
    }

    public void compile() {
        this.compile(new HashMap<String, String>());
    }

    public void compile(Map<String, String> map) {
        if (this.program != null) {
            CL.clReleaseProgram((cl_program)this.program);
            CL.clReleaseKernel((cl_kernel)this.kernel);
        }
        cl_program cl_program2 = CL.clCreateProgramWithSource((cl_context)this.context, (int)1, (String[])new String[]{this.cl}, null, null);
        if (map.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("-D ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            CL.clBuildProgram((cl_program)cl_program2, (int)0, null, (String)stringBuilder.toString(), null, null);
        } else {
            CL.clBuildProgram((cl_program)cl_program2, (int)0, null, null, null, null);
        }
        this.kernel = CL.clCreateKernel((cl_program)cl_program2, (String)this.kernelName, null);
    }

    public cl_mem createArrayReadOnly(float[] fArray) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)36L, (long)(4 * fArray.length), (Pointer)Pointer.to((float[])fArray), null);
    }

    public cl_mem createArrayReadOnly(int[] nArray) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)36L, (long)(4 * nArray.length), (Pointer)Pointer.to((int[])nArray), null);
    }

    public cl_mem createFloatArrayWriteOnly(int n) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)1L, (long)(4 * n), null, null);
    }

    public String getCLSource() {
        return this.cl;
    }

    public cl_context getContext() {
        return this.context;
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public int getGlobalWork() {
        return this.globalWork;
    }

    public cl_kernel getKernel() {
        return this.kernel;
    }

    public int getLocalWork() {
        return this.localWork;
    }

    public int getMaxWorkGroupSize() {
        return (int)this.getWorkGroupLong(4528);
    }

    public cl_program getProgram() {
        return this.program;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public long getWorkGroupLong(int n) {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        CL.clGetKernelWorkGroupInfo((cl_kernel)this.kernel, (cl_device_id)this.device.getDevice(), (int)n, (long)8L, (Pointer)Pointer.to((long[])lArray), (long[])lArray2);
        return lArray[0];
    }

    public void prepareKernel() {
        if (this.kernel == null) {
            throw new EncogEngineError("Must compile CL kernel before using it.");
        }
    }

    public void release() {
        if (this.program != null) {
            CL.clReleaseProgram((cl_program)this.program);
            CL.clReleaseKernel((cl_kernel)this.kernel);
            this.program = null;
            this.kernel = null;
        }
    }

    public void releaseBuffer(cl_mem cl_mem2) {
        CL.clReleaseMemObject((cl_mem)cl_mem2);
    }

    public void setArg(int n, cl_mem cl_mem2) {
        CL.clSetKernelArg((cl_kernel)this.getKernel(), (int)n, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject[])new NativePointerObject[]{cl_mem2}));
    }

    public void setCLSource(String string) {
        this.cl = string;
    }

    public void setGlobalWork(int n) {
        this.globalWork = n;
    }

    public void setLocalWork(int n) {
        this.localWork = n;
    }
}

