/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import org.encog.engine.opencl.EncogCLItem;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.EncogCLQueue;
import org.encog.engine.util.Format;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.cl_device_id;

public class EncogCLDevice
extends EncogCLItem {
    private final cl_device_id device;
    private final EncogCLPlatform platform;
    private final boolean cpu;
    private final EncogCLQueue queue;

    public EncogCLDevice(EncogCLPlatform encogCLPlatform, cl_device_id cl_device_id2) {
        this.platform = encogCLPlatform;
        this.setEnabled(true);
        this.device = cl_device_id2;
        this.setName(this.getDeviceString(4139).trim());
        this.setVender(this.getDeviceString(4140));
        long l = this.getDeviceLong(4096);
        this.cpu = l == 2L;
        this.queue = new EncogCLQueue(this);
    }

    public cl_device_id getDevice() {
        return this.device;
    }

    public long getDeviceLong(int n) {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        CL.clGetDeviceInfo((cl_device_id)this.device, (int)n, (long)8L, (Pointer)Pointer.to((long[])lArray), (long[])lArray2);
        return lArray[0];
    }

    public String getDeviceString(int n) {
        byte[] byArray = new byte[255];
        long[] lArray = new long[1];
        CL.clGetDeviceInfo((cl_device_id)this.device, (int)n, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), (long[])lArray);
        String string = new String(byArray, 0, (int)lArray[0]);
        return string;
    }

    public long getGlobalMemorySize() {
        return this.getDeviceLong(4127);
    }

    public long getLocalMemorySize() {
        return this.getDeviceLong(4131);
    }

    public long getMaxClockFrequency() {
        return this.getDeviceLong(4108);
    }

    public long getMaxComputeUnits() {
        return this.getDeviceLong(4098);
    }

    public long getMaxWorkGroupSize() {
        return this.getDeviceLong(4100);
    }

    public EncogCLPlatform getPlatform() {
        return this.platform;
    }

    public EncogCLQueue getQueue() {
        return this.queue;
    }

    public boolean isCPU() {
        return this.cpu;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.cpu) {
            stringBuilder.append("CPU:");
        } else {
            stringBuilder.append("GPU:");
        }
        stringBuilder.append(this.getName());
        stringBuilder.append(",ComputeUnits:");
        stringBuilder.append(this.getMaxComputeUnits());
        stringBuilder.append(",ClockFreq:");
        stringBuilder.append(this.getMaxClockFrequency());
        stringBuilder.append(",LocalMemory=");
        stringBuilder.append(Format.formatMemory(this.getLocalMemorySize()));
        stringBuilder.append(",GlobalMemory=");
        stringBuilder.append(Format.formatMemory(this.getGlobalMemorySize()));
        return stringBuilder.toString();
    }
}

