/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineDataSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.prop.TrainFlatNetworkProp;
import org.encog.engine.util.BoundNumbers;
import org.encog.engine.util.EngineArray;

public class TrainFlatNetworkSCG
extends TrainFlatNetworkProp {
    protected static final double FIRST_SIGMA = 1.0E-4;
    protected static final double FIRST_LAMBDA = 1.0E-6;
    private boolean restart = false;
    private double lambda2 = 0.0;
    private double lambda = 1.0E-6;
    private int k;
    private boolean success = true;
    private double magP = 0.0;
    private final double[] p;
    private final double[] r;
    private final double[] weights;
    private double delta = 0.0;
    private double oldError = 0.0;
    private final double[] oldWeights;
    private final double[] oldGradient;
    private boolean mustInit;

    public TrainFlatNetworkSCG(FlatNetwork flatNetwork, EngineDataSet engineDataSet) {
        super(flatNetwork, engineDataSet);
        this.weights = EngineArray.arrayCopy(flatNetwork.getWeights());
        int n = this.weights.length;
        this.oldWeights = new double[n];
        this.oldGradient = new double[n];
        this.p = new double[n];
        this.r = new double[n];
        this.mustInit = true;
    }

    public void calculateGradients() {
        int n = this.getNetwork().getOutputCount();
        super.calculateGradients();
        double d = -2.0 / (double)this.gradients.length / (double)n;
        int n2 = 0;
        while (n2 < this.gradients.length) {
            int n3 = n2++;
            this.gradients[n3] = this.gradients[n3] * d;
        }
    }

    private void init() {
        int n = this.weights.length;
        this.calculateGradients();
        this.k = 1;
        for (int i = 0; i < n; ++i) {
            this.p[i] = this.r[i] = -this.gradients[i];
        }
        this.mustInit = false;
    }

    public void iteration() {
        double d;
        if (this.mustInit) {
            this.init();
        }
        int n = this.weights.length;
        if (this.restart) {
            this.lambda = 1.0E-6;
            this.lambda2 = 0.0;
            this.k = 1;
            this.success = true;
            this.restart = false;
        }
        if (this.success) {
            int n2;
            this.magP = EngineArray.vectorProduct(this.p, this.p);
            d = 1.0E-4 / Math.sqrt(this.magP);
            EngineArray.arrayCopy(this.gradients, this.oldGradient);
            EngineArray.arrayCopy(this.weights, this.oldWeights);
            this.oldError = this.getError();
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = n2;
                this.weights[n3] = this.weights[n3] + d * this.p[n2];
            }
            EngineArray.arrayCopy(this.weights, this.network.getWeights());
            this.calculateGradients();
            this.delta = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                double d2 = (this.gradients[n2] - this.oldGradient[n2]) / d;
                this.delta += this.p[n2] * d2;
            }
        }
        this.delta += (this.lambda - this.lambda2) * this.magP;
        if (this.delta <= 0.0) {
            this.lambda2 = 2.0 * (this.lambda - this.delta / this.magP);
            this.delta = this.lambda * this.magP - this.delta;
            this.lambda = this.lambda2;
        }
        d = EngineArray.vectorProduct(this.p, this.r);
        double d3 = d / this.delta;
        for (int i = 0; i < n; ++i) {
            this.weights[i] = this.oldWeights[i] + d3 * this.p[i];
        }
        EngineArray.arrayCopy(this.weights, this.network.getWeights());
        this.calculateGradients();
        double d4 = 2.0 * this.delta * (this.oldError - this.getError()) / (d * d);
        if (d4 >= 0.0) {
            double d5 = 0.0;
            for (int i = 0; i < n; ++i) {
                double d6 = -this.gradients[i];
                d5 += d6 * this.r[i];
                this.r[i] = d6;
            }
            this.lambda2 = 0.0;
            this.success = true;
            if (this.k >= n) {
                this.restart = true;
                EngineArray.arrayCopy(this.r, this.p);
            } else {
                double d7 = (EngineArray.vectorProduct(this.r, this.r) - d5) / d;
                for (int i = 0; i < n; ++i) {
                    this.p[i] = this.r[i] + d7 * this.p[i];
                }
                this.restart = false;
            }
            if (d4 >= 0.75) {
                this.lambda *= 0.25;
            }
        } else {
            EngineArray.arrayCopy(this.oldWeights, this.weights);
            this.currentError = this.oldError;
            this.lambda2 = this.lambda;
            this.success = false;
        }
        if (d4 < 0.25) {
            this.lambda += this.delta * (1.0 - d4) / this.magP;
        }
        this.lambda = BoundNumbers.bound(this.lambda);
        ++this.k;
        EngineArray.arrayCopy(this.weights, this.network.getWeights());
    }

    public double updateWeight(double[] dArray, double[] dArray2, int n) {
        return 0.0;
    }
}

