/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import java.io.Serializable;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.flat.FlatLayer;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.engine.util.EngineArray;

public class FlatNetworkRBF
extends FlatNetwork
implements Serializable {
    private RadialBasisFunction[] rbf;

    public FlatNetworkRBF() {
    }

    public FlatNetworkRBF(int n, int n2, int n3, RadialBasisFunction[] radialBasisFunctionArray) {
        FlatLayer[] flatLayerArray = new FlatLayer[3];
        this.rbf = radialBasisFunctionArray;
        double[] dArray = new double[]{1.0};
        flatLayerArray[0] = new FlatLayer(new ActivationLinear(), n, 0.0, dArray);
        flatLayerArray[1] = new FlatLayer(new ActivationLinear(), n2, 0.0, dArray);
        flatLayerArray[2] = new FlatLayer(new ActivationLinear(), n3, 0.0, dArray);
        this.init(flatLayerArray);
    }

    public FlatNetworkRBF clone() {
        FlatNetworkRBF flatNetworkRBF = new FlatNetworkRBF();
        this.cloneFlatNetwork(flatNetworkRBF);
        flatNetworkRBF.rbf = this.rbf;
        return flatNetworkRBF;
    }

    public void compute(double[] dArray, double[] dArray2) {
        int n = this.getLayerIndex()[1];
        for (int i = 0; i < this.rbf.length; ++i) {
            double d;
            this.getLayerOutput()[n + i] = d = this.rbf[i].calculate(dArray);
        }
        this.computeLayer(1);
        EngineArray.arrayCopy(this.getLayerOutput(), 0, dArray2, 0, this.getOutputCount());
    }
}

