/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import org.encog.engine.network.activation.ActivationFunction;

public class FlatLayer {
    private final ActivationFunction activation;
    private final int count;
    private final double biasActivation;
    private FlatLayer contextFedBy;

    public FlatLayer(ActivationFunction activationFunction, int n, double d, double[] dArray) {
        this.activation = activationFunction;
        this.count = n;
        this.biasActivation = d;
        this.contextFedBy = null;
    }

    public ActivationFunction getActivation() {
        return this.activation;
    }

    public double getBiasActivation() {
        return this.biasActivation;
    }

    public int getContectCount() {
        if (this.contextFedBy == null) {
            return 0;
        }
        return this.contextFedBy.getCount();
    }

    public FlatLayer getContextFedBy() {
        return this.contextFedBy;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotalCount() {
        if (this.contextFedBy == null) {
            return this.getCount() + (this.isBias() ? 1 : 0);
        }
        return this.getCount() + (this.isBias() ? 1 : 0) + this.contextFedBy.getCount();
    }

    public boolean isBias() {
        return Math.abs(this.biasActivation) > 1.0E-6;
    }

    public void setContextFedBy(FlatLayer flatLayer) {
        this.contextFedBy = flatLayer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FlatLayer: count=");
        stringBuilder.append(this.count);
        stringBuilder.append(",bias=");
        if (this.isBias()) {
            stringBuilder.append(this.biasActivation);
        } else {
            stringBuilder.append("false");
        }
        if (this.contextFedBy != null) {
            stringBuilder.append(",contextFed=");
            if (this.contextFedBy == this) {
                stringBuilder.append("itself");
            } else {
                stringBuilder.append(this.contextFedBy);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

