/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency.job;

import org.encog.engine.StatusReportable;
import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.concurrency.TaskGroup;
import org.encog.engine.concurrency.job.JobUnitContext;
import org.encog.engine.concurrency.job.JobUnitWorker;

public abstract class ConcurrentJob {
    private final StatusReportable report;
    private int totalTasks;
    private int current;
    private boolean shouldStop = false;

    public ConcurrentJob(StatusReportable statusReportable) {
        this.report = statusReportable;
        this.current = 1;
    }

    public abstract int loadWorkload();

    public abstract void performJobUnit(JobUnitContext var1);

    public void process() {
        Object object;
        this.totalTasks = this.loadWorkload();
        int n = 0;
        TaskGroup taskGroup = EngineConcurrency.getInstance().createTaskGroup();
        while ((object = this.requestNextTask()) != null && !this.shouldStop) {
            JobUnitContext jobUnitContext = new JobUnitContext();
            jobUnitContext.setJobUnit(object);
            jobUnitContext.setOwner(this);
            jobUnitContext.setTaskNumber(++n);
            JobUnitWorker jobUnitWorker = new JobUnitWorker(jobUnitContext);
            EngineConcurrency.getInstance().processTask(jobUnitWorker, taskGroup);
        }
        taskGroup.waitForComplete();
        EngineConcurrency.getInstance().checkError();
    }

    public void reportStatus(JobUnitContext jobUnitContext, String string) {
        this.report.report(this.totalTasks, this.current++, string);
    }

    public abstract Object requestNextTask();

    public boolean getShouldStop() {
        return this.shouldStop;
    }

    public void stop() {
        this.shouldStop = true;
    }
}

