/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.util.Arrays;

public class Statistics {
    public static final int MAXIMIZATION = 1;
    public static final int MINIMIZATION = 2;
    public static final int ABSMAXIMIZATION = 3;
    public static final int ABSMINIMIZATION = 4;

    private Statistics() {
    }

    public static double norm_vec(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double max(double[] vals) {
        double max = vals[0];
        for (double v : vals) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static double min(double[] vals) {
        double min = vals[0];
        for (double v : vals) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double range(double[] vals) {
        double min = vals[0];
        double max = vals[0];
        for (double v : vals) {
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return max - min;
    }

    public static int length(double[] vals) {
        return vals.length;
    }

    public static double median(double[] vals) {
        return Statistics.quantile(vals, 0.5);
    }

    public static double mean(double[] vals) {
        return Statistics.sum(vals) / (double)vals.length;
    }

    public static double stddev(double[] vals) {
        double mean = Statistics.mean(vals);
        double squareSum = 0.0;
        for (double v : vals) {
            squareSum += v * v;
        }
        return Math.sqrt(squareSum / (double)vals.length - mean * mean);
    }

    public static double stderr(double[] vals) {
        return Statistics.stddev(vals) / Math.sqrt(vals.length);
    }

    public static double variance(double[] vals) {
        double stddev = Statistics.stddev(vals);
        return stddev * stddev;
    }

    public static double meandev(double[] vals) {
        double mean = Statistics.mean(vals);
        int size = vals.length;
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            sum += Math.abs(vals[i] - mean);
        }
        return sum / (double)size;
    }

    public static double sum(double[] vals) {
        double sum = 0.0;
        for (double v : vals) {
            sum += v;
        }
        return sum;
    }

    public static double product(double[] vals) {
        double prod = 1.0;
        for (double v : vals) {
            prod *= v;
        }
        return prod;
    }

    public static double quantile(double[] vals, double phi) {
        if (vals.length == 0) {
            return 0.0;
        }
        double[] sortedElements = Arrays.copyOf(vals, vals.length);
        Arrays.sort(sortedElements);
        int n = sortedElements.length;
        double index = phi * (double)(n - 1);
        int lhs = (int)index;
        double delta = index - (double)lhs;
        double result = lhs == n - 1 ? sortedElements[lhs] : (1.0 - delta) * sortedElements[lhs] + delta * sortedElements[lhs + 1];
        return result;
    }

    public static double lag1(double[] vals) {
        double mean = Statistics.mean(vals);
        int size = vals.length;
        double q = 0.0;
        double v = (vals[0] - mean) * (vals[0] - mean);
        for (int i = 1; i < size; ++i) {
            double delta0 = vals[i - 1] - mean;
            double delta1 = vals[i] - mean;
            q += (delta0 * delta1 - q) / (double)(i + 1);
            v += (delta1 * delta1 - v) / (double)(i + 1);
        }
        double r1 = q / v;
        return r1;
    }

    public static double rmse(double[] sim, double[] obs, double missingValue) {
        Statistics.sameArrayLen(sim, obs);
        double error = 0.0;
        int len = 0;
        for (int i = 0; i < sim.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            double diff = sim[i] - obs[i];
            error += diff * diff;
            ++len;
        }
        return Math.sqrt(error /= (double)len);
    }

    public static double norm_rmse(double[] obs, double[] sim, double missing) {
        double sum = 0.0;
        double size = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missing)) continue;
            sum += obs[i];
            size += 1.0;
        }
        double measuredMean = sum / size;
        int N = Math.min(obs.length, sim.length);
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < N; ++i) {
            if (!(obs[i] > missing)) continue;
            numerator += (obs[i] - sim[i]) * (obs[i] - sim[i]);
            denominator += (obs[i] - measuredMean) * (obs[i] - measuredMean);
        }
        if (denominator == 0.0) {
            throw new RuntimeException("Error: The denominator is 0.\nThis happens if all observed values are equal to their mean.");
        }
        return Math.sqrt(numerator / denominator);
    }

    public static double nbias(double[] sim, double[] obs, double missingValue) {
        Statistics.sameArrayLen(sim, obs);
        double sum = 0.0;
        double sumsim = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            sum += sim[i] - obs[i];
            sumsim += sim[i];
        }
        return sum / sumsim;
    }

    public static double pbias(double[] obs, double[] sim, double missingValue) {
        return Statistics.nbias(obs, sim, missingValue) * 100.0;
    }

    public static double absVolumeError(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        double volError = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            volError += sim[i] - obs[i];
        }
        return Math.abs(volError);
    }

    public static double nashSutcliffe(double[] obs, double[] sim, double pow, double missingValue) {
        int pre_size;
        Statistics.sameArrayLen(obs, sim);
        int steps = pre_size = sim.length;
        double sum_vd = 0.0;
        double size = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            sum_vd += obs[i];
            size += 1.0;
        }
        double mean_vd = sum_vd / size;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            if (!(obs[i] > missingValue)) continue;
            td_vd += Math.pow(Math.abs(obs[i] - sim[i]), pow);
            vd_mean += Math.pow(Math.abs(obs[i] - mean_vd), pow);
        }
        return 1.0 - td_vd / vd_mean;
    }

    public static double nashSutcliffeLog(double[] obs, double[] sim, double pow, double missingValue) {
        int i;
        Statistics.sameArrayLen(obs, sim);
        int size = sim.length;
        double sum_log_pd = 0.0;
        double sum_log_vd = 0.0;
        double[] log_preData = new double[size];
        double[] log_valData = new double[size];
        int validPairs = 0;
        for (i = 0; i < size; ++i) {
            if (sim[i] <= 0.0 || obs[i] <= 0.0) {
                log_preData[i] = -1.0;
                log_valData[i] = -1.0;
            }
            if (sim[i] == 0.0 && obs[i] == 0.0) {
                log_preData[i] = 0.0;
                log_valData[i] = 0.0;
                ++validPairs;
            }
            if (!(sim[i] > 0.0) || !(obs[i] > 0.0)) continue;
            log_preData[i] = Math.log(sim[i]);
            log_valData[i] = Math.log(obs[i]);
            ++validPairs;
        }
        for (i = 0; i < size; ++i) {
            if (!(log_preData[i] >= 0.0)) continue;
            sum_log_pd += log_preData[i];
            sum_log_vd += log_valData[i];
        }
        double mean_log_vd = sum_log_vd / (double)validPairs;
        double pd_log_vd = 0.0;
        double vd_log_mean = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!(log_preData[i2] >= 0.0)) continue;
            pd_log_vd += Math.pow(Math.abs(log_valData[i2] - log_preData[i2]), pow);
            vd_log_mean += Math.pow(Math.abs(log_valData[i2] - mean_log_vd), pow);
        }
        return 1.0 - pd_log_vd / vd_log_mean;
    }

    public static double err_sum(double[] obs, double[] sim) {
        double volError = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            volError += sim[i] - obs[i];
        }
        return volError;
    }

    public static double ioa(double[] obs, double[] sim, double pow, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        int steps = sim.length;
        double sum_obs = 0.0;
        double len = 0.0;
        for (int i = 0; i < steps; ++i) {
            if (!(obs[i] > missingValue)) continue;
            sum_obs += obs[i];
            len += 1.0;
        }
        double mean_obs = sum_obs / len;
        double td_vd = 0.0;
        double abs_sqDevi = 0.0;
        for (int i = 0; i < steps; ++i) {
            if (!(obs[i] > missingValue)) continue;
            td_vd += Math.pow(Math.abs(obs[i] - sim[i]), pow);
            abs_sqDevi += Math.pow(Math.abs(sim[i] - mean_obs) + Math.abs(obs[i] - mean_obs), pow);
        }
        return 1.0 - td_vd / abs_sqDevi;
    }

    public static double[] linearReg(double[] xData, double[] yData) {
        Statistics.sameArrayLen(xData, yData);
        double sumX = 0.0;
        double sumY = 0.0;
        double prod = 0.0;
        int nstat = xData.length;
        double[] regCoef = new double[3];
        double meanYValue = Statistics.mean(yData);
        double meanXValue = Statistics.mean(xData);
        for (int i = 0; i < nstat; ++i) {
            sumX += (xData[i] - meanXValue) * (xData[i] - meanXValue);
            sumY += (yData[i] - meanYValue) * (yData[i] - meanYValue);
            prod += (xData[i] - meanXValue) * (yData[i] - meanYValue);
        }
        if (sumX > 0.0 && sumY > 0.0) {
            regCoef[1] = prod / sumX;
            regCoef[0] = meanYValue - regCoef[1] * meanXValue;
            regCoef[2] = Math.pow(prod / Math.sqrt(sumX * sumY), 2.0);
        }
        return regCoef;
    }

    public static double intercept(double[] xData, double[] yData) {
        return Statistics.linearReg(xData, yData)[0];
    }

    public static double gradient(double[] xData, double[] yData) {
        return Statistics.linearReg(xData, yData)[1];
    }

    public static double r2(double[] xData, double[] yData) {
        return Statistics.linearReg(xData, yData)[2];
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static float round(float val, int places) {
        return (float)Statistics.round((double)val, places);
    }

    public static double random(double min, double max) {
        assert (max > min);
        return min + Math.random() * (max - min);
    }

    public static double runoffCoefficientError(double[] obs, double[] sim, double[] precip) {
        Statistics.sameArrayLen(sim, obs, precip);
        double mean_pred = Statistics.mean(sim);
        double mean_val = Statistics.mean(obs);
        double mean_ppt = Statistics.mean(precip);
        double error = Math.abs(mean_pred / mean_ppt - mean_val / mean_ppt);
        return Math.sqrt(error);
    }

    public static double transformedRmse(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(sim, obs);
        double error = 0.0;
        double z_pred = 0.0;
        double z_val = 0.0;
        int len = 0;
        for (int i = 0; i < sim.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            z_pred = (Math.pow(1.0 + sim[i], 0.3) - 1.0) / 0.3;
            z_val = (Math.pow(1.0 + obs[i], 0.3) - 1.0) / 0.3;
            error += (z_pred - z_val) * (z_pred - z_val);
            ++len;
        }
        return Math.sqrt(error / (double)len);
    }

    public static double pearsonsCorrelation(double[] obs, double[] sim, double missingValue) {
        int j;
        Statistics.sameArrayLen(obs, sim);
        double syy = 0.0;
        double sxy = 0.0;
        double sxx = 0.0;
        double ay = 0.0;
        double ax = 0.0;
        int n = 0;
        for (j = 0; j < obs.length; ++j) {
            if (!(obs[j] > missingValue)) continue;
            ax += obs[j];
            ay += sim[j];
            ++n;
        }
        if (n == 0) {
            throw new RuntimeException("Pearson's Correlation cannot be calculated due to no observed values");
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < obs.length; ++j) {
            if (!(obs[j] > missingValue)) continue;
            double xt = obs[j] - ax;
            double yt = sim[j] - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return sxy / Math.sqrt(sxx * syy);
    }

    public static double absDiff(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        double abs = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            abs += Math.abs(obs[i] - sim[i]);
        }
        return abs;
    }

    public static double stderrReg(double[] regcoeff, double[] obs, double[] sim) {
        Statistics.sameArrayLen(obs, sim);
        double sum = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            double res = sim[i] * regcoeff[1] + regcoeff[0];
            sum += (obs[i] - res) * (obs[i] - res);
        }
        return Math.sqrt(sum / (double)(obs.length - 2));
    }

    public static double absDiffLog(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        int N = obs.length;
        double abs = 0.0;
        for (int i = 0; i < N; ++i) {
            if (!(obs[i] > missingValue)) continue;
            double measured = obs[i];
            double simulated = sim[i];
            if (measured == 0.0) {
                measured = 1.0E-7;
            } else if (measured < 0.0) {
                throw new RuntimeException("Error on Absolute Difference (log): Observed value is negative.");
            }
            if (simulated == 0.0) {
                simulated = 1.0E-7;
            } else if (simulated < 0.0) {
                throw new RuntimeException("Error on Absolute Difference (log): Simulated value is negative.");
            }
            abs += Math.abs(Math.log(measured) - Math.log(simulated));
        }
        return abs;
    }

    public static double dsGrad(double[] obs, double[] sim) {
        Statistics.sameArrayLen(obs, sim);
        int dsLength = sim.length;
        double[] cumPred = new double[dsLength];
        double[] cumVali = new double[dsLength];
        double cp = 0.0;
        double cv = 0.0;
        for (int i = 0; i < dsLength; ++i) {
            cumPred[i] = cp += sim[i];
            cumVali[i] = cv += obs[i];
        }
        double[] regCoef = Statistics.linearReg(cumVali, cumPred);
        return regCoef[1];
    }

    public static double flf(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        int count = 0;
        double FLF = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue) || sim[i] == 0.0 || obs[i] == 0.0) continue;
            ++count;
            FLF += (Math.log(sim[i]) - Math.log(obs[i])) * (Math.log(sim[i]) - Math.log(obs[i]));
        }
        return FLF / (double)count;
    }

    public static double fhf(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        int count = 0;
        double FHF = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            ++count;
            FHF += (sim[i] - obs[i]) * (sim[i] - obs[i]);
        }
        return FHF / (double)count;
    }

    public static double kge(double[] obs, double[] sim, double missingValue) {
        Statistics.sameArrayLen(obs, sim);
        int contamedia = 0;
        double sommamediaoss = 0.0;
        double sommamediasim = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            ++contamedia;
            sommamediaoss += obs[i];
            sommamediasim += sim[i];
        }
        double mediaoss = sommamediaoss / (double)contamedia;
        double mediasim = sommamediasim / (double)contamedia;
        int count = 0;
        double numvaprev = 0.0;
        double coef1_den = 0.0;
        double numR = 0.0;
        double den1R = 0.0;
        double den2R = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            if (!(obs[i] > missingValue)) continue;
            ++count;
            coef1_den += (obs[i] - mediaoss) * (obs[i] - mediaoss);
            numR += (obs[i] - mediaoss) * (sim[i] - mediasim);
            den1R += (obs[i] - mediaoss) * (obs[i] - mediaoss);
            den2R += (sim[i] - mediasim) * (sim[i] - mediasim);
            numvaprev += (sim[i] - mediasim) * (sim[i] - mediasim);
        }
        double sdosservati = Math.sqrt(coef1_den / (double)(count - 1));
        double sdsimulati = Math.sqrt(numvaprev / (double)(count - 1));
        double R = numR / (Math.sqrt(den1R) * Math.sqrt(den2R));
        double alpha = sdsimulati / sdosservati;
        double beta = mediasim / mediaoss;
        return 1.0 - Math.sqrt((R - 1.0) * (R - 1.0) + (alpha - 1.0) * (alpha - 1.0) + (beta - 1.0) * (beta - 1.0));
    }

    private static void sameArrayLen(double[] ... arr) {
        int len = arr[0].length;
        for (double[] a : arr) {
            if (a.length == len) continue;
            throw new IllegalArgumentException("obs and sim data have not same size (" + a.length + "/" + len + ")");
        }
    }
}

