/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.util.Random;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Range;

public class Ranges {

    public static class Gen {
        Access in;
        double min;
        double max;

        public Gen(Object comp, String field, double min, double max) {
            ComponentAccess cp = new ComponentAccess(comp);
            this.in = cp.input(field);
            if (max < min) {
                throw new RuntimeException("min>max");
            }
            this.min = min;
            this.max = max;
        }

        public Gen(Object comp, String field) {
            ComponentAccess cp = new ComponentAccess(comp);
            this.in = cp.input(field);
            Range range = this.in.getField().getAnnotation(Range.class);
            if (range == null) {
                throw new IllegalArgumentException(field);
            }
            this.min = range.min();
            this.max = range.max();
        }

        public double next(Random r) {
            double d = r.nextDouble() * (this.max - this.min) + this.min;
            try {
                this.in.setFieldValue(new Double(d));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return d;
        }
    }

    public static class Check {
        Access out;
        double min;
        double max;

        public Check(Object comp, String field) {
            ComponentAccess cp = new ComponentAccess(comp);
            this.out = cp.output(field);
            Range range = this.out.getField().getAnnotation(Range.class);
            if (range == null) {
                throw new IllegalArgumentException(field);
            }
            if (range.max() < range.min()) {
                throw new RuntimeException("min>max " + range);
            }
            this.min = range.min();
            this.max = range.max();
        }

        public Check(Object comp, String field, double min, double max) {
            ComponentAccess cp = new ComponentAccess(comp);
            this.out = cp.output(field);
            if (max < min) {
                throw new RuntimeException("min>max ");
            }
            this.min = min;
            this.max = max;
        }

        public boolean check() {
            double d;
            Object o = null;
            try {
                o = this.out.getFieldValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            if (o == null) {
                return false;
            }
            return !(o instanceof Double) || this.min <= (d = ((Double)o).doubleValue()) && d <= this.max;
        }
    }
}

