/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.io.File;
import java.io.StringWriter;
import java.util.logging.Logger;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Out;
import oms3.util.Processes;

public class ProcessComponent {
    static final Logger log = Logger.getLogger(ProcessComponent.class.getName());
    @In
    public String exe;
    @In
    public String[] args = new String[0];
    @In
    public String working_dir;
    @Out
    public String stdout;
    @Out
    public String stderr;
    @Out
    public int exitValue;

    @Execute
    public void execute() {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        try {
            Processes p = new Processes(new File(this.exe));
            p.setArguments(this.args);
            if (this.working_dir != null && !this.working_dir.isEmpty()) {
                p.setWorkingDirectory(new File(this.working_dir));
            }
            p.redirectOutput(out);
            p.redirectError(err);
            this.exitValue = p.exec();
            this.stdout = out.toString();
            this.stderr = err.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

