/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import oms3.annotations.DLL;

public class NativeLibraries {
    private NativeLibraries() {
    }

    public static <T extends Library> T bind(Class<T> intf) {
        DLL dll = intf.getAnnotation(DLL.class);
        if (dll == null) {
            throw new IllegalArgumentException("Missing DLL annotation.");
        }
        return NativeLibraries.bind(dll.value(), intf);
    }

    public static <T extends Library> T bind(String name, Class<T> intf) {
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("Expected interface, but got '" + intf + "'.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty library name.");
        }
        Native.setProtected(true);
        return (T)((Library)Native.loadLibrary(name, intf));
    }
}

