/*
 * Decompiled with CFR 0.152.
 */
package oms3.nap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.nap.AnnotationHandler;
import oms3.nap.AnnotationParser;
import oms3.nap.JNAFortran;
import oms3.nap.NetLogo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JNAComponentTask
extends Task {
    List<FileSet> filesets = new ArrayList<FileSet>();
    File destdir;
    String dllName;
    boolean genlogging;
    boolean gensingleton;

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setDllName(String dllName) {
        this.dllName = dllName;
    }

    public void setGenlogging(boolean genlogging) {
        this.genlogging = genlogging;
    }

    public void setGensingleton(boolean gensingleton) {
        this.gensingleton = gensingleton;
    }

    public void setGenprotected(boolean genprotected) {
    }

    public void execute() throws BuildException {
        if (this.filesets.size() < 1) {
            throw new BuildException("No 'fileset'(s).");
        }
        if (this.destdir == null) {
            throw new BuildException("No 'destdir'");
        }
        ArrayList<JNAFortran> jna_FTN = new ArrayList<JNAFortran>();
        try {
            for (FileSet fs : this.filesets) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File baseDir = ds.getBasedir();
                for (String incFile : ds.getIncludedFiles()) {
                    if (!this.needsRebuild(baseDir, this.destdir, incFile)) continue;
                    File genFile = new File(this.destdir, incFile.substring(0, incFile.lastIndexOf(46)) + ".java");
                    File srcFile = new File(baseDir, incFile);
                    if (incFile.endsWith("nlogo")) {
                        NetLogo nl = new NetLogo(){

                            @Override
                            public void log(String msg) {
                                JNAComponentTask.this.log(msg, 3);
                            }
                        };
                        nl.setGenFile(genFile);
                        nl.setSrcFile(srcFile);
                        nl.setRelativeFile(incFile);
                        AnnotationParser.handle(srcFile, (AnnotationHandler)nl);
                    } else {
                        JNAFortran ah = new JNAFortran(this){

                            @Override
                            public void log(String msg) {
                                JNAComponentTask.this.log(msg, 3);
                            }
                        };
                        ah.setLibname(this.dllName);
                        ah.setGenFile(genFile);
                        ah.setSrcFile(srcFile);
                        ah.setRelativeFile(incFile);
                        AnnotationParser.handle(srcFile, (AnnotationHandler)ah);
                        if (ah.valid) {
                            jna_FTN.add(ah);
                        }
                    }
                    if (!genFile.exists()) continue;
                    this.log("Generating source: " + genFile, 2);
                }
            }
            if (jna_FTN.size() > 0) {
                File f = JNAFortran.generateLib(this, this.destdir, jna_FTN);
                this.log("Generating JNA source: " + f, 2);
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private boolean needsRebuild(File srcDir, File genSrcDir, String src) {
        File genFile = new File(genSrcDir, src.substring(0, src.lastIndexOf(46)) + ".java");
        if (!genFile.exists()) {
            return true;
        }
        File srcFile = new File(srcDir, src);
        return srcFile.lastModified() > genFile.lastModified();
    }
}

