/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractPageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreaker;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;

public class PageSequenceLayoutManager
extends AbstractPageSequenceLayoutManager {
    private static Log log = LogFactory.getLog((Class)PageSequenceLayoutManager.class);
    private PageProvider pageProvider;

    public PageSequenceLayoutManager(AreaTreeHandler ath, org.apache.fop.fo.pagination.PageSequence pseq) {
        super(ath, pseq);
        this.pageProvider = new PageProvider(ath, pseq);
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    protected org.apache.fop.fo.pagination.PageSequence getPageSequence() {
        return (org.apache.fop.fo.pagination.PageSequence)this.pageSeq;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this;
    }

    public void activateLayout() {
        this.initialize();
        LineArea title = null;
        if (this.getPageSequence().getTitleFO() != null) {
            try {
                ContentLayoutManager clm = this.getLayoutManagerMaker().makeContentLayoutManager(this, this.getPageSequence().getTitleFO());
                title = (LineArea)clm.getParentArea(null);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        PageSequence pageSequenceAreaObject = new PageSequence(title);
        pageSequenceAreaObject.setLanguage(this.getPageSequence().getLanguage());
        pageSequenceAreaObject.setCountry(this.getPageSequence().getCountry());
        areaTreeModel.startPageSequence(pageSequenceAreaObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting layout");
        }
        this.curPage = this.makeNewPage(false, false);
        PageBreaker breaker = new PageBreaker(this);
        int flowBPD = this.getCurrentPV().getBodyRegion().getRemainingBPD();
        breaker.doLayout(flowBPD);
        this.finishPage();
    }

    public void finishPageSequence() {
        if (this.pageSeq.hasId()) {
            this.idTracker.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        this.getPageSequence().releasePageSequence();
        String masterReference = this.getPageSequence().getMasterReference();
        PageSequenceMaster pageSeqMaster = this.pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(masterReference);
        if (pageSeqMaster != null) {
            pageSeqMaster.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ending layout");
        }
    }

    protected Page createPage(int pageNumber, boolean isBlank) {
        return this.pageProvider.getPage(isBlank, pageNumber, 0);
    }

    private void layoutSideRegion(int regionID) {
        SideRegion reg = (SideRegion)this.curPage.getSimplePageMaster().getRegion(regionID);
        if (reg == null) {
            return;
        }
        StaticContent sc = this.getPageSequence().getStaticContent(reg.getRegionName());
        if (sc == null) {
            return;
        }
        StaticContentLayoutManager lm = this.getLayoutManagerMaker().makeStaticContentLayoutManager(this, sc, reg);
        lm.doLayout();
    }

    protected void finishPage() {
        this.layoutSideRegion(35);
        this.layoutSideRegion(34);
        this.layoutSideRegion(38);
        this.layoutSideRegion(37);
        super.finishPage();
    }
}

