/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.javac;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.tools.javac.JavaAwareResolveVisitor;
import org.codehaus.groovy.tools.javac.JavaStubGenerator;

public class JavaStubCompilationUnit
extends CompilationUnit {
    private final List javaSources = new LinkedList();

    public JavaStubCompilationUnit(CompilerConfiguration config, GroovyClassLoader classLoader, File outputDirectory) {
        super(config, null, classLoader);
        this.addPhaseOperation(new JavaResolverOperation(), 3);
        this.addPhaseOperation(new StubGeneratorOperation(outputDirectory), 3);
    }

    public void gotoPhase(int phase) throws CompilationFailedException {
        super.gotoPhase(phase);
        if (phase == 4) {
            this.javaSources.clear();
        }
    }

    public void addSourceFile(File file) {
        if (file.getName().endsWith(".java")) {
            this.addJavaSource(file);
        } else {
            this.addSource(file);
        }
    }

    private void addJavaSource(File file) {
        String path = file.getAbsolutePath();
        Iterator iter = this.javaSources.iterator();
        while (iter.hasNext()) {
            if (!path.equals(iter.next())) continue;
            return;
        }
        this.javaSources.add(path);
    }

    private boolean haveJavaSources() {
        return !this.javaSources.isEmpty();
    }

    private class JavaResolverOperation
    extends CompilationUnit.PrimaryClassNodeOperation {
        private JavaResolverOperation() {
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode node) throws CompilationFailedException {
            if (JavaStubCompilationUnit.this.haveJavaSources()) {
                JavaAwareResolveVisitor v = new JavaAwareResolveVisitor(JavaStubCompilationUnit.this);
                v.startResolving(node, source);
            }
        }
    }

    private class StubGeneratorOperation
    extends CompilationUnit.PrimaryClassNodeOperation {
        private final JavaStubGenerator generator;

        public StubGeneratorOperation(File outputDirectory) {
            outputDirectory.mkdirs();
            boolean java5 = false;
            String target = JavaStubCompilationUnit.this.getConfiguration().getTargetBytecode();
            if (target != null && target.trim().equals("1.5")) {
                java5 = true;
            }
            this.generator = new JavaStubGenerator(outputDirectory, true, java5);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode node) throws CompilationFailedException {
            if (JavaStubCompilationUnit.this.haveJavaSources()) {
                try {
                    this.generator.generateClass(node);
                }
                catch (Exception e) {
                    source.addException(e);
                }
            }
        }
    }
}

