/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class LongitudeFirstFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
CoordinateOperationAuthorityFactory,
DatumAuthorityFactory {
    public static final String SYSTEM_DEFAULT_KEY = "org.geotools.referencing.forceXY";

    public LongitudeFirstFactory() {
        this((Hints)null);
    }

    public LongitudeFirstFactory(Hints userHints) {
        super(userHints, 90 + LongitudeFirstFactory.relativePriority());
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints userHints, Hints.Key key) {
        Object value = null;
        if (userHints != null) {
            value = userHints.get((Object)key);
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority() {
        try {
            if (Boolean.getBoolean(SYSTEM_DEFAULT_KEY)) {
                return 10;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -10;
    }

    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        Hints backingStoreHints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, ThreadedEpsgFactory.class);
        backingStoreHints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.FALSE);
        try {
            factory = (AbstractAuthorityFactory)ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", backingStoreHints);
        }
        catch (org.geotools.factory.FactoryNotFoundException exception) {
            throw new FactoryNotFoundException((Exception)((Object)exception));
        }
        catch (FactoryRegistryException exception) {
            throw new FactoryException((Exception)((Object)exception));
        }
        return new OrderedAxisAuthorityFactory(factory, new Hints(this.hints), null);
    }
}

