/*
 * Decompiled with CFR 0.152.
 */
package optas.test;

import java.util.Arrays;
import optas.core.AbstractFunction;
import optas.core.AbstractModel;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.efficiencies.LogLikelihood;
import optas.test.DataReader;
import optas.test.HymodVrugt;
import optas.test.NashSutcliffe;

public class LeafRiverExample {
    static AbstractFunction f = new AbstractFunction(){

        @Override
        public double[] evaluate(double[] x) throws SampleLimitException, ObjectiveAchievedException {
            double[] result = LeafRiverExample.LeafRiverTest(x[0], x[1], x[2], x[3], x[4], 3.0);
            if (Double.isNaN(result[0]) || Double.isInfinite(result[0]) || result[0] > 100.0) {
                return new double[]{100.0, 100.0};
            }
            return result;
        }

        @Override
        public String[] getInputFactorNames() {
            return new String[]{"alpha", "bexp", "cmax", "kq", "ks"};
        }

        @Override
        public String[] getOutputFactorNames() {
            return new String[]{"e1", "e2"};
        }

        @Override
        public int getInputDimension() {
            return 5;
        }

        @Override
        public int getOutputDimension() {
            return 2;
        }

        @Override
        public double[][] getRange() {
            return new double[][]{{0.1, 0.99}, {0.1, 2.0}, {1.0, 500.0}, {0.1, 0.99}, {0.0, 0.1}};
        }

        @Override
        public void log(String msg) {
            System.out.println(msg);
        }
    };

    public static AbstractModel getModel() {
        return f;
    }

    public static double[] LeafRiverTest(double alpha, double bexp, double cmax, double kq, double ks, double nq) {
        DataReader reader = new DataReader();
        HymodVrugt hymod = new HymodVrugt();
        LogLikelihood logLikelihood = new LogLikelihood();
        NashSutcliffe e1 = new NashSutcliffe(1.0);
        NashSutcliffe e2 = new NashSutcliffe(2.0);
        reader.fileName = "E:/ModelData/Testgebiete/Hymod/LeafCatch2.dat";
        hymod.alpha = alpha;
        hymod.bexp = bexp;
        hymod.cmax = cmax;
        hymod.kq = kq;
        hymod.ks = ks;
        hymod.nq = nq;
        reader.init();
        hymod.init();
        int TIMESTEP_COUNT_TOTAL = 4110;
        int TIMESTEP_COUNT_INITIAL = 1554;
        double[] obsQ = new double[TIMESTEP_COUNT_TOTAL - TIMESTEP_COUNT_INITIAL];
        double[] simQ = new double[TIMESTEP_COUNT_TOTAL - TIMESTEP_COUNT_INITIAL];
        for (int i = 0; i < TIMESTEP_COUNT_TOTAL; ++i) {
            reader.run();
            hymod.precip = reader.precip;
            hymod.pet = reader.pet;
            hymod.run();
            if (i <= TIMESTEP_COUNT_INITIAL) continue;
            simQ[i - TIMESTEP_COUNT_INITIAL] = hymod.mq;
            obsQ[i - TIMESTEP_COUNT_INITIAL] = reader.obsRunoff;
        }
        return new double[]{e1.calcNormative(obsQ, simQ), e2.calcNormative(obsQ, simQ)};
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(LeafRiverExample.LeafRiverTest(0.98, 0.58, 293.0, 0.48, 1.0E-4, 3.0)));
    }
}

