/*
 * Decompiled with CFR 0.152.
 */
package optas.regression.gaussian.mean;

import Jama.Matrix;
import java.util.Arrays;
import optas.regression.gaussian.mean.MeanFunction;

public class Sum
extends MeanFunction {
    MeanFunction a;
    MeanFunction b;

    public Sum(MeanFunction a, MeanFunction b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public Matrix eval(double[] hyp, double[][] x) {
        int n2;
        int n1 = this.a.getNumberOfHyperparameters(x);
        if (hyp.length < n1 + (n2 = this.b.getNumberOfHyperparameters(x))) {
            System.out.println("Error expected number of hyperparameters was " + (n1 + n2) + " but received " + hyp.length);
        }
        double[] hyp1 = Arrays.copyOfRange(hyp, 0, n1);
        double[] hyp2 = Arrays.copyOfRange(hyp, n1, n1 + n2);
        return this.a.eval(hyp1, x).plus(this.b.eval(hyp2, x));
    }

    @Override
    public int getNumberOfHyperparameters(double[][] x) {
        return this.a.getNumberOfHyperparameters(x) + this.b.getNumberOfHyperparameters(x);
    }

    @Override
    public double[][] getHyperparameterRange(double[][] x) {
        int n = this.getNumberOfHyperparameters(x);
        int n1 = this.a.getNumberOfHyperparameters(x);
        int n2 = this.b.getNumberOfHyperparameters(x);
        double[][] range = new double[n][2];
        for (int i = 0; i < n; ++i) {
            range[i] = i < n1 ? this.a.getHyperparameterRange(x)[i] : this.b.getHyperparameterRange(x)[i - n1];
        }
        return range;
    }

    public String toString() {
        return this.a.toString() + " + " + this.b.toString();
    }
}

