/*
 * Decompiled with CFR 0.152.
 */
package optas.regression.gaussian.cov;

import Jama.Matrix;
import optas.regression.GaussianProcessRegression;
import optas.regression.gaussian.cov.CovarianceFunction;

public class covSEiso
extends CovarianceFunction {
    @Override
    public Matrix selfVariance(double[] hyp, double[][] x) {
        int j;
        int n = x[0].length;
        int D = x.length;
        double ell = Math.exp(hyp[0]);
        double sf2 = Math.exp(2.0 * hyp[1]);
        double[][] x_copy = new double[D][n];
        for (int i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < D; ++j2) {
                x_copy[j2][i] = x[j2][i] / ell;
            }
        }
        double[] mean = new double[n];
        int i = 0;
        while (i < n) {
            for (j = 0; j < D; ++j) {
                int n2 = i;
                mean[n2] = mean[n2] + x_copy[j][i];
            }
            int n3 = i++;
            mean[n3] = mean[n3] / (double)D;
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < D; ++j) {
                double[] dArray = x_copy[j];
                int n4 = i;
                dArray[n4] = dArray[n4] - mean[i];
            }
        }
        Matrix K = new Matrix(D, 1);
        for (int i2 = 0; i2 < K.getColumnDimension(); ++i2) {
            for (int j3 = 0; j3 < K.getRowDimension(); ++j3) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += x_copy[i2][k] * x_copy[i2][k] + x_copy[j3][k] * x_copy[j3][k] - 2.0 * x_copy[i2][k] * x_copy[j3][k];
                }
                double r = sf2 * Math.exp(-sum / 2.0);
                K.set(j3, i2, r);
            }
        }
        return K;
    }

    @Override
    public Matrix crossVariance(double[] hyp, double[][] x, double[][] xs) {
        int j;
        int n = x[0].length;
        int D12 = x.length;
        int D22 = xs.length;
        if (x[0].length != xs[0].length) {
            System.out.println("'Error: column lengths must agree.'");
            return null;
        }
        double ell = Math.exp(hyp[0]);
        double sf2 = Math.exp(2.0 * hyp[1]);
        double[][] x_copy = new double[D12][n];
        double[][] xs_copy = new double[D22][n];
        for (int i = 0; i < n; ++i) {
            int j2;
            for (j2 = 0; j2 < D12; ++j2) {
                x_copy[j2][i] = x[j2][i] / ell;
            }
            for (j2 = 0; j2 < D22; ++j2) {
                xs_copy[j2][i] = xs[j2][i] / ell;
            }
        }
        double[] mean = new double[n];
        int i = 0;
        while (i < n) {
            for (j = 0; j < D12; ++j) {
                int n2 = i;
                mean[n2] = mean[n2] + x_copy[j][i];
            }
            for (j = 0; j < D22; ++j) {
                int n3 = i;
                mean[n3] = mean[n3] + xs_copy[j][i];
            }
            int n4 = i++;
            mean[n4] = mean[n4] / (double)(D12 + D22);
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < D12; ++j) {
                double[] dArray = x_copy[j];
                int n5 = i;
                dArray[n5] = dArray[n5] - mean[i];
            }
            for (j = 0; j < D22; ++j) {
                double[] dArray = xs_copy[j];
                int n6 = i;
                dArray[n6] = dArray[n6] - mean[i];
            }
        }
        Matrix C = new Matrix(D12, D22);
        for (int i2 = 0; i2 < D12; ++i2) {
            for (int j3 = 0; j3 < D22; ++j3) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += x_copy[i2][k] * x_copy[i2][k] + xs_copy[j3][k] * xs_copy[j3][k] - 2.0 * x_copy[i2][k] * xs_copy[j3][k];
                }
                double r = sf2 * Math.exp(-sum / 2.0);
                C.set(i2, j3, r);
            }
        }
        return C;
    }

    @Override
    public Matrix eval(double[] hyp, double[][] x) {
        int j;
        int n = x[0].length;
        int D = x.length;
        double ell = Math.exp(hyp[0]);
        double sf2 = Math.exp(2.0 * hyp[1]);
        double[][] x_copy = new double[D][n];
        for (int i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < D; ++j2) {
                x_copy[j2][i] = x[j2][i] / ell;
            }
        }
        double[] mean = new double[n];
        int i = 0;
        while (i < n) {
            for (j = 0; j < D; ++j) {
                int n2 = i;
                mean[n2] = mean[n2] + x_copy[j][i];
            }
            int n3 = i++;
            mean[n3] = mean[n3] / (double)D;
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < D; ++j) {
                double[] dArray = x_copy[j];
                int n4 = i;
                dArray[n4] = dArray[n4] - mean[i];
            }
        }
        Matrix C = new Matrix(D, D);
        for (int i2 = 0; i2 < D; ++i2) {
            for (int j3 = i2; j3 < D; ++j3) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += x_copy[i2][k] * x_copy[i2][k] + x_copy[j3][k] * x_copy[j3][k] - 2.0 * x_copy[i2][k] * x_copy[j3][k];
                }
                double r = sf2 * Math.exp(-sum / 2.0);
                C.set(i2, j3, r);
                C.set(j3, i2, r);
            }
        }
        return C;
    }

    public static void main(String[] args) {
        double[][] x = GaussianProcessRegression.generateRandomX();
        double[] hyp = new double[]{Math.log(0.25), Math.log(1.0)};
        covSEiso test = new covSEiso();
        Matrix C = test.eval(hyp, x);
        for (int i = 0; i < C.getRowDimension(); ++i) {
            for (int j = 0; j < C.getRowDimension(); ++j) {
                System.out.print(C.get(i, j) + "\t");
            }
            System.out.println("");
        }
    }

    @Override
    public int getNumberOfHyperparameters(double[][] x) {
        return 2;
    }

    @Override
    public double[][] getHyperparameterRange(double[][] x) {
        return new double[][]{{-4.0, 4.0}, {-4.0, 4.0}};
    }

    public String toString() {
        return "covSEiso";
    }
}

