/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.text.DecimalFormat;
import optas.gui.wizard.OPTASWizardException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.Optimization;
import optas.gui.wizard.Parameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizationController;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SpatialRelaxation;
import optas.optimizer.management.Tools;

@JAMSComponentDescription(title="OptimizationScheduler", author="Christian Fischer", description="Performs a chain of optimizations")
public class SimpleOptimizationController
extends OptimizationController {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="optimizer class")
    public Attribute.String optimizationClassName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="parameterization of optimization method", defaultValue="")
    public Attribute.String parameterization;
    Optimization optimization = null;

    @Override
    public void init() {
        super.init();
        try {
            this.optimization = new Optimization(null);
            for (int i = 0; i < this.m; ++i) {
                Objective obj = new Objective(this.efficiencyNames[i]);
                this.optimization.addObjective(obj);
            }
            DecimalFormat df = new DecimalFormat("0000");
            for (int i = 0; i < this.n; ++i) {
                Parameter p = new Parameter("param_" + df.format(i));
                p.setLowerBound(this.lowBound[i]);
                p.setUpperBound(this.upBound[i]);
                double[] x0i = new double[this.x0.length];
                for (int j = 0; j < this.x0.length; ++j) {
                    x0i[j] = this.x0[j][i];
                }
                p.setStartValue(x0i);
                this.optimization.addParameter(p);
            }
            this.optimization.setName("opt1");
            OptimizerDescription desc = Tools.getStandardOptimizerDesc(this.parameterization.getValue());
            desc.setOptimizerClassName(this.optimizationClassName.getValue());
            this.optimization.setOptimizerDescription(desc);
        }
        catch (OPTASWizardException e) {
            e.printStackTrace();
            System.out.println(e.toString());
            this.getModel().getRuntime().sendHalt(e.toString());
        }
    }

    public long getNumberOfIterations() {
        return (long)((NumericOptimizerParameter)this.optimization.getOptimizerDescription().getPropertyMap().get("maxn")).getValue();
    }

    @Override
    public void procedure() {
        OptimizationController.OptimizationConfiguration conf = new OptimizationController.OptimizationConfiguration(this.optimization);
        if (this.optimization.getOptimizerDescription().getDoSpatialRelaxation().isValue()) {
            SpatialRelaxation relaxation = new SpatialRelaxation();
            relaxation.setRelaxationParameter(this.relaxationParameter);
            relaxation.applyProcedure(conf);
        } else {
            conf.loadOptimizer(null).optimize();
        }
        this.solution = DefaultDataFactory.getDataFactory().createEntity();
        this.solution.setObject("solution", this.getStatistics().getParetoFront());
    }
}

