/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import optas.optimizer.management.Statistics;

public class SampleFactory
implements Serializable {
    private ArrayList<Sample> sampleList = new ArrayList();
    Statistics stats = new Statistics(this.sampleList);

    public Statistics getStatistics() {
        return this.stats;
    }

    public void injectSample(Sample s) {
        this.sampleList.add(s);
    }

    public ArrayList<Sample> getSampleList() {
        return this.sampleList;
    }

    public SampleSO getSampleSO(double[] x, double fx) {
        SampleSO s = new SampleSO(x, fx);
        this.sampleList.add(s);
        this.stats.fireChangeEvent();
        return s;
    }

    public Sample getSample(double[] x, double[] fx) {
        Sample s = new Sample(x, fx);
        this.sampleList.add(s);
        this.stats.fireChangeEvent();
        return s;
    }

    public int getSize() {
        return this.sampleList.size();
    }

    public static class SampleComperator
    implements Comparator,
    Serializable {
        private int order = 1;
        private boolean[] subset = null;

        public SampleComperator(boolean decreasing_order, boolean[] subset) {
            this.order = decreasing_order ? -1 : 1;
            this.subset = subset;
        }

        public SampleComperator(boolean decreasing_order) {
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            int m = ((Sample)d1).fx.length;
            if (((Sample)d1).fx.length != ((Sample)d2).fx.length) {
                return 0;
            }
            int ord = 0;
            for (int i = 0; i < m; ++i) {
                if (this.subset != null && !this.subset[i]) continue;
                int nextOrd = ((Sample)d1).fx[i] < ((Sample)d2).fx[i] ? -1 * this.order : (Math.abs(((Sample)d1).fx[i] - ((Sample)d2).fx[i]) < 1.0E-9 ? 0 * this.order : 1 * this.order);
                if (ord == 0) {
                    ord = nextOrd;
                    continue;
                }
                if (ord == nextOrd || nextOrd == 0) continue;
                return 0;
            }
            return ord;
        }
    }

    public static class SampleIndexComperator
    implements Comparator {
        private int order = 1;
        private int index;

        public SampleIndexComperator(int index, boolean decreasing_order) {
            this.order = decreasing_order ? -1 : 1;
            this.index = index;
        }

        public int compare(Object d1, Object d2) {
            if (((Sample)d1).fx.length != ((Sample)d2).fx.length) {
                return 0;
            }
            int ord = 0;
            int i = this.index;
            ord = ((Sample)d1).fx[i] < ((Sample)d2).fx[i] ? -1 * this.order : (Math.abs(((Sample)d1).fx[i] - ((Sample)d2).fx[i]) < 1.0E-9 ? 0 * this.order : 1 * this.order);
            return ord;
        }
    }

    public static class SampleSOComperator
    implements Comparator {
        private int order = 1;

        public SampleSOComperator(boolean decreasing_order) {
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            return Double.compare(((SampleSO)d1).f(), ((SampleSO)d2).f()) * this.order;
        }
    }

    public class SampleSO
    extends Sample {
        private SampleSO() {
        }

        private SampleSO(double[] x, double fx) {
            super(x, new double[]{fx});
            this.fx[0] = fx;
            this.x = super.getParameter();
        }

        @Override
        public SampleSO clone() {
            Sample x = super.clone();
            SampleSO s = new SampleSO();
            s.fx = x.fx;
            s.x = x.x;
            return s;
        }

        public double f() {
            return this.fx[0];
        }
    }

    public class Sample
    implements Serializable {
        public double[] x;
        protected double[] fx;

        private Sample() {
        }

        private Sample(double[] x, double[] fx) {
            if (x == null || fx == null) {
                return;
            }
            this.fx = Arrays.copyOf(fx, fx.length);
            this.x = Arrays.copyOf(x, x.length);
        }

        public double[] getParameter() {
            return this.x;
        }

        public double[] F() {
            return this.fx;
        }

        public Sample clone() {
            Sample cpy = new Sample();
            cpy.x = new double[this.x.length];
            cpy.fx = new double[this.fx.length];
            System.arraycopy(this.x, 0, cpy.x, 0, this.x.length);
            System.arraycopy(this.fx, 0, cpy.fx, 0, this.fx.length);
            return cpy;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Sample)) {
                return false;
            }
            Sample s = (Sample)obj;
            if (s.x.length != this.x.length) {
                return false;
            }
            if (s.fx.length != this.fx.length) {
                return false;
            }
            for (int i = 0; i < this.x.length; ++i) {
                if (s.x[i] == this.x[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Arrays.hashCode(this.x);
            hash = 79 * hash + Arrays.hashCode(this.fx);
            return hash;
        }

        public String toString() {
            int i;
            String s = "";
            for (i = 0; i < this.x.length; ++i) {
                s = s + this.x[i] + "\t";
            }
            for (i = 0; i < this.fx.length; ++i) {
                s = s + this.fx[i] + "\t";
            }
            return s;
        }
    }
}

