/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.io.SerializableBufferedWriter;
import jams.model.JAMSComponentDescription;
import java.util.Random;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class PostSampling
extends Optimizer {
    SerializableBufferedWriter writer = null;
    Random rnd = new Random();
    public SampleFactory.Sample[] initialSimplex = null;
    public double threshold = 0.1;
    double[] minBound = null;
    double[] maxBound = null;

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public double[][] getRange() {
        return new double[][]{this.minBound, this.maxBound};
    }

    @Override
    public OptimizerDescription getDescription() {
        return OptimizerLibrary.getDefaultOptimizerDescription(PostSampling.class.getSimpleName(), PostSampling.class.getName(), 500, false);
    }

    private double[] transform(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = this.lowBound[i] + x[i] * (this.upBound[i] - this.lowBound[i]);
        }
        return y;
    }

    private double[] reTransform(double[] y) {
        double[] x = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            x[i] = this.upBound[i] - this.lowBound[i] > 0.0 ? (y[i] - this.lowBound[i]) / (this.upBound[i] - this.lowBound[i]) : y[i] - this.lowBound[i];
        }
        return x;
    }

    @Override
    public void procedure() throws ObjectiveAchievedException {
        this.minBound = new double[this.n];
        this.maxBound = new double[this.n];
        try {
            SampleFactory.Sample y0 = this.getSample(this.x0[0]);
            for (int i = 0; i < this.n; ++i) {
                double lplus = 0.5;
                double lminus = 0.5;
                for (int k = 0; k < 8; ++k) {
                    double[] xiplus = new double[this.n];
                    double[] ximinus = new double[this.n];
                    for (int j = 0; j < this.n; ++j) {
                        xiplus[j] = this.reTransform(this.x0[0])[j] + lplus;
                        if (xiplus[j] > 1.0) {
                            xiplus[j] = 1.0;
                        }
                        ximinus[j] = this.reTransform(this.x0[0])[j] - lminus;
                        if (!(ximinus[j] < 0.0)) continue;
                        ximinus[j] = 0.0;
                    }
                    SampleFactory.Sample sPlus = this.getSample(this.transform(xiplus));
                    SampleFactory.Sample sMinus = this.getSample(this.transform(ximinus));
                    boolean isValidPlus = true;
                    boolean isValidMinus = true;
                    for (int j = 0; j < this.m; ++j) {
                        if (!(sPlus.F()[j] < (1.0 + this.threshold) * y0.F()[j])) {
                            isValidPlus = false;
                        }
                        if (sMinus.F()[j] < (1.0 + this.threshold) * y0.F()[j]) continue;
                        isValidMinus = false;
                    }
                    if (isValidPlus) {
                        lplus += lplus / 2.0;
                        this.maxBound[i] = this.transform(xiplus)[i];
                    } else {
                        lplus -= lplus / 2.0;
                    }
                    if (isValidMinus) {
                        lminus += lminus / 2.0;
                        this.minBound[i] = this.transform(ximinus)[i];
                        continue;
                    }
                    lminus -= lminus / 2.0;
                }
            }
            while (true) {
                double[] v = new double[this.n];
                for (int j = 0; j < this.n; ++j) {
                    v[j] = this.rnd.nextDouble() * (this.maxBound[j] - this.minBound[j]) + this.minBound[j];
                }
                this.getSample(v);
            }
        }
        catch (SampleLimitException sampleLimitException) {
            return;
        }
    }
}

