/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import Jama.Matrix;
import jams.JAMS;
import jams.model.JAMSComponentDescription;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.directsearch.NelderMead;
import optas.optimizer.directsearch.PatternSearch;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="SCE Optimization routine", author="Christian Fischer", description="optimization routine based on Duan et al. 1992")
public class MultiModelSCE
extends Optimizer {
    public String linearConstraintMatrixA;
    public String linearConstraintVectorB;
    public double complexesCount;
    public double pcento;
    public double kstop;
    public double peps;
    int N;
    int p;
    int s;
    int m;
    int iterationCounter = 0;
    SampleFactory.SampleSO[] pool;

    private double calcCrowdingValue(SampleFactory.Sample x) {
        double sharingRadius = 30.0;
        double alpha = 1.0;
        double crowding = 1.0;
        if (x == null) {
            return 0.0;
        }
        for (SampleFactory.SampleSO y : this.pool) {
            if (y == null) {
                return 0.0;
            }
            if (y.equals(x)) continue;
            double[] p1 = x.getParameter();
            double[] p2 = y.getParameter();
            double y1 = x.F()[0];
            double y2 = y.F()[0];
            double d = 0.0;
            for (int i = 0; i < this.n; ++i) {
                d += (p1[i] - p2[i]) * (p1[i] - p2[i]);
            }
            if (!((d = Math.sqrt(d)) < sharingRadius) || !(y2 < y1)) continue;
            crowding += 1.0 - Math.pow(d / sharingRadius, alpha);
        }
        return x.F()[0];
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.iterationCounter = 0;
        if (this.linearConstraintMatrixA != null && this.linearConstraintVectorB != null) {
            int i;
            StringTokenizer tok = new StringTokenizer(this.linearConstraintMatrixA, ";");
            int n = tok.countTokens();
            int m = -1;
            for (i = 0; i < n; ++i) {
                StringTokenizer line_tok = new StringTokenizer(tok.nextToken(), ",");
                if (m == -1) {
                    m = line_tok.countTokens();
                }
                if (m != line_tok.countTokens()) {
                    this.log(JAMS.i18n((String)"Linear_Constraint_Matrix_dimension_mismatch"));
                    return false;
                }
                for (int j = 0; j < m; ++j) {
                    String number = line_tok.nextToken();
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(number);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log(JAMS.i18n((String)"Cant_read_Linear_Constraint_Matrix_because_there_are_unparseable_elements") + ":" + e.toString());
                        return false;
                    }
                }
            }
            tok = new StringTokenizer(this.linearConstraintVectorB, ";");
            n = tok.countTokens();
            for (i = 0; i < n; ++i) {
                String number = tok.nextToken();
                double value = 0.0;
                try {
                    value = Double.parseDouble(number);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.log(JAMS.i18n((String)"Cant_read_Linear_Constraint_Matrix_because_there_are_unparseable_elements") + ":" + e.toString());
                }
            }
        }
        if (this.complexesCount <= 0.0) {
            this.log("warning: NumberOfComplexes_value_not_specified, set to default of 2");
            this.complexesCount = 2.0;
        }
        if (this.pcento <= 0.0) {
            this.log("warning: pcento_value_not_specified, set to default of 0.1");
            this.pcento = 0.1;
        }
        if (this.peps <= 0.0) {
            this.log("warning: peps_value_not_specified, set to default of 0.00001");
            this.peps = 1.0E-5;
        }
        if (this.kstop <= 0.0) {
            this.log("warning: kstop_value_not_specified, set to default of 10");
            this.kstop = 10.0;
        }
        return true;
    }

    private double NormalizedgeometricRange(SampleFactory.SampleSO[] x, double[] bound) {
        if (x.length == 0) {
            return 0.0;
        }
        double mean = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                min = Math.min(min, x[j].x[i]);
                max = Math.max(max, x[j].x[i]);
            }
            mean += (max - min) / bound[i];
        }
        return mean /= (double)this.n;
    }

    private int find(int[] lcs, int startindex, int endindex, int value) {
        for (int i = startindex; i < endindex; ++i) {
            if (lcs[i] != value) continue;
            return i;
        }
        return -1;
    }

    private SampleFactory.SampleSO cceua2(SampleFactory.SampleSO[] s, double[] bl, double[] bu) throws SampleLimitException, ObjectiveAchievedException {
        SampleFactory.SampleSO fnew;
        int nps = s.length;
        int nopt = s[0].x.length;
        int n = nps;
        int m = nopt;
        double alpha = 1.0;
        double beta = 0.5;
        SampleFactory.SampleSO sw = s[n - 1];
        double[] ce = new double[nopt];
        int i = 0;
        while (i < nopt) {
            ce[i] = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                int n2 = i;
                ce[n2] = ce[n2] + s[j].x[i];
            }
            int n3 = i++;
            ce[n3] = ce[n3] / (double)(n - 1);
        }
        double[] snew = new double[nopt];
        for (int i2 = 0; i2 < nopt; ++i2) {
            snew[i2] = ce[i2] + alpha * (ce[i2] - sw.x[i2]);
        }
        int ibound = 0;
        for (int i3 = 0; i3 < nopt; ++i3) {
            if (snew[i3] - bl[i3] < 0.0) {
                ibound = 1;
            }
            if (!(bu[i3] - snew[i3] < 0.0)) continue;
            ibound = 2;
        }
        if (ibound >= 1) {
            snew = this.randomSampler();
        }
        if ((fnew = this.getSampleSO(snew)).f() > sw.f()) {
            for (int i4 = 0; i4 < nopt; ++i4) {
                snew[i4] = sw.x[i4] + beta * (ce[i4] - s[n - 1].x[i4]);
            }
            fnew = this.getSampleSO(snew);
        }
        if (fnew.f() > sw.f()) {
            snew = this.randomSampler();
            fnew = this.getSampleSO(snew);
        }
        return fnew;
    }

    private SampleFactory.SampleSO cceua(SampleFactory.SampleSO[] simplex, double[] bl, double[] bu) throws SampleLimitException, ObjectiveAchievedException {
        Matrix A = new Matrix(bl.length + bu.length, this.n);
        Matrix b = new Matrix(bl.length + bu.length, 1);
        for (int i = 0; i < bl.length; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i == j) {
                    A.set(i, j, -1.0);
                    A.set(i + this.n, j, 1.0);
                    continue;
                }
                A.set(i, j, 0.0);
                A.set(i + this.n, j, 0.0);
            }
            b.set(i, 0, -bl[i]);
            b.set(i + this.n, 0, bu[i]);
        }
        NelderMead SearchMethod = new NelderMead();
        return ((PatternSearch)SearchMethod).step(this, simplex, A, b, this.lowBound, this.upBound);
    }

    private void EvolveSubPopulation(int nspl, int nps, int npg, int nopt, SampleFactory.SampleSO[] c, double[] bu, double[] bl) {
        for (int loop = 0; loop < nspl; ++loop) {
            int i;
            int[] lcs = new int[nps];
            lcs[0] = 0;
            for (int k3 = 1; k3 < nps; ++k3) {
                int idx;
                int lpos = 0;
                for (int iter = 0; iter < 1000 && (idx = this.find(lcs, 0, k3, lpos = (int)Math.floor((double)npg + 0.5 - Math.sqrt(((double)npg + 0.5) * ((double)npg + 0.5) - (double)(npg * (npg + 1)) * this.randomValue())))) != -1; ++iter) {
                }
                lcs[k3] = lpos;
            }
            Arrays.sort(lcs);
            SampleFactory.SampleSO[] s = new SampleFactory.SampleSO[nps];
            for (i = 0; i < nps; ++i) {
                s[i] = c[lcs[i]].clone();
            }
            try {
                s[nps - 1] = this.cceua(s, bl, bu);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            for (i = 0; i < nps; ++i) {
                c[lcs[i]] = s[i];
            }
            Arrays.sort(c, new SampleSOCrowdingComperator(false));
        }
    }

    public SampleFactory.SampleSO sceua(double[][] x0, double[] bl, double[] bu, int maxn, int kstop, double pcento, double peps, int ngs, int iseed) {
        int i;
        int nopt = x0.length;
        int npg = 10 * nopt + 1;
        int nps = nopt + 1;
        int nspl = npg;
        int npt = npg * ngs;
        double[] bound = new double[nopt];
        for (i = 0; i < nopt; ++i) {
            bound[i] = bu[i] - bl[i];
        }
        i = 0;
        this.pool = new SampleFactory.SampleSO[npt];
        try {
            for (i = 0; i < this.pool.length; ++i) {
                this.pool[i] = x0 != null && i < x0.length ? this.getSampleSO(x0[i]) : this.getSampleSO(this.randomSampler());
            }
        }
        catch (SampleLimitException e) {
            System.out.println(e);
            return this.pool[i];
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.pool[i];
        }
        int nloop = 0;
        Arrays.sort(this.pool, new SampleSOCrowdingComperator(false));
        double gnrng = this.NormalizedgeometricRange(this.pool, bound);
        this.log(JAMS.i18n((String)"The_Inital_Loop_0"));
        this.log(JAMS.i18n((String)"Best") + this.pool[0].toString());
        this.log(JAMS.i18n((String)"Worst") + this.pool[npt - 1].toString());
        if (gnrng < peps) {
            this.log(JAMS.i18n((String)"THE_POPULATION_HAS_CONVERGED_TO_A_PRESPECIFIED_SMALL_PARAMETER_SPACE"));
        }
        nloop = 0;
        double[] criter = new double[kstop];
        double criter_change = 100000.0;
        while (criter_change > pcento) {
            ++nloop;
            for (int igs = 0; igs < ngs; ++igs) {
                int[] k1 = new int[npg];
                int[] k2 = new int[npg];
                for (i = 0; i < npg; ++i) {
                    k1[i] = i;
                    k2[i] = k1[i] * ngs + igs;
                }
                SampleFactory.SampleSO[] c = new SampleFactory.SampleSO[npg];
                for (i = 0; i < npg; ++i) {
                    c[k1[i]] = this.pool[k2[i]].clone();
                }
                this.EvolveSubPopulation(nspl, nps, npg, nopt, c, bu, bl);
                for (i = 0; i < npg; ++i) {
                    this.pool[k2[i]] = c[k1[i]];
                }
            }
            Arrays.sort(this.pool, new SampleSOCrowdingComperator(false));
            gnrng = this.NormalizedgeometricRange(this.pool, bound);
            this.log(JAMS.i18n((String)"Evolution_Loop") + ":" + nloop + JAMS.i18n((String)"Trial") + " " + this.getIterationCounter());
            this.log(JAMS.i18n((String)"Best") + this.pool[0]);
            this.log(JAMS.i18n((String)"Worst") + this.pool[this.pool.length - 1]);
            if (gnrng < peps) {
                this.log(JAMS.i18n((String)"THE_POPULATION_HAS_CONVERGED_TO_A_PRESPECIFIED_SMALL_PARAMETER_SPACE"));
            }
            for (i = 0; i < kstop - 1; ++i) {
                criter[i] = criter[i + 1];
            }
            criter[kstop - 1] = this.calcCrowdingValue(this.pool[0]);
            if (nloop < kstop) continue;
            criter_change = Math.abs(criter[0] - criter[kstop - 1]) * 100.0;
            double criter_mean = 0.0;
            for (i = 0; i < kstop; ++i) {
                criter_mean += Math.abs(criter[i]);
            }
            if (!((criter_change /= (criter_mean /= (double)kstop)) < pcento)) continue;
            this.log(JAMS.i18n((String)"THE_BEST_POINT_HAS_IMPROVED_IN_LAST") + " " + kstop + " " + JAMS.i18n((String)"LOOPS_BY"));
            this.log(JAMS.i18n((String)"LESS_THAN_THE_THRESHOLD") + " " + pcento + "%");
            this.log(JAMS.i18n((String)"CONVERGENCY_HAS_ACHIEVED_BASED_ON_OBJECTIVE_FUNCTION_CRITERIA"));
        }
        this.log(JAMS.i18n((String)"SEARCH_WAS_STOPPED_AT_TRIAL_NUMBER") + " " + this.getIterationCounter());
        this.log(JAMS.i18n((String)"NORMALIZED_GEOMETRIC_RANGE") + " " + gnrng);
        this.log(JAMS.i18n((String)"THE_BEST_POINT_HAS_IMPROVED_IN_LAST") + kstop + " " + JAMS.i18n((String)"LOOPS_BY") + " " + criter_change + "%");
        for (int j = 0; j < this.pool.length; ++j) {
            this.log(this.pool[j].toString());
        }
        this.log("######################STOPP#################");
        return this.pool[0];
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        this.sceua(this.x0, this.lowBound, this.upBound, (int)this.getMaxn(), (int)this.kstop, this.pcento, this.peps, (int)this.complexesCount, 10);
    }

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(MultiModelSCE.class.getSimpleName(), MultiModelSCE.class.getName(), 6, false);
        desc.addParameter(new NumericOptimizerParameter("complexesCount", JAMS.i18n((String)"number_of_complexes"), 2.0, 1.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("pcento", JAMS.i18n((String)"worst_acceptable_improvement"), 0.05, 1.0E-6, 1.0));
        desc.addParameter(new NumericOptimizerParameter("peps", JAMS.i18n((String)"minimal_geometric_population"), 1.0E-5, 1.0E-6, 1.0));
        desc.addParameter(new NumericOptimizerParameter("kstop", JAMS.i18n((String)"kStop"), 10.0, 1.0, 100.0));
        return desc;
    }

    public class SampleSOCrowdingComperator
    implements Comparator {
        private int order = 1;

        public SampleSOCrowdingComperator(boolean decreasing_order) {
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            double y2;
            double y1 = MultiModelSCE.this.calcCrowdingValue((SampleFactory.SampleSO)d1);
            if (y1 < (y2 = MultiModelSCE.this.calcCrowdingValue((SampleFactory.SampleSO)d2))) {
                return -1 * this.order;
            }
            if (y1 == y2) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

