/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import Jama.Matrix;
import jams.JAMS;
import jams.model.JAMSComponentDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.directsearch.ImplicitFiltering;
import optas.optimizer.directsearch.MDS;
import optas.optimizer.directsearch.NelderMead;
import optas.optimizer.directsearch.PatternSearch;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.StringOptimizerParameter;
import optas.optimizer.parallel.ParallelSequence;

@JAMSComponentDescription(title="SCE Optimization routine", author="Christian Fischer", description="optimization routine based on Duan et al. 1992")
public class SCE
extends Optimizer {
    public String linearConstraintMatrixA;
    public String linearConstraintVectorB;
    public double complexesCount;
    public double pcento;
    public double kstop;
    public double peps;
    public boolean parallelExecution = false;
    public double threadCount = 12.0;
    public String excludeFiles = "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log";
    transient DataCollection collection = null;
    int N;
    int p;
    int s;
    int m;
    int iterationCounter = 0;
    PatternSearch SearchMethod = null;
    Matrix LinearConstraints_A = null;
    Matrix LinearConstraints_b = null;
    ParallelSequence pseq = null;

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(String excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.iterationCounter = 0;
        if (this.linearConstraintMatrixA != null && this.linearConstraintVectorB != null) {
            int i;
            StringTokenizer tok = new StringTokenizer(this.linearConstraintMatrixA, ";");
            int n = tok.countTokens();
            int m = -1;
            this.LinearConstraints_A = null;
            for (i = 0; i < n; ++i) {
                StringTokenizer line_tok = new StringTokenizer(tok.nextToken(), ",");
                if (m == -1) {
                    m = line_tok.countTokens();
                    this.LinearConstraints_A = new Matrix(n, m);
                }
                if (m != line_tok.countTokens()) {
                    this.log(JAMS.i18n((String)"Linear_Constraint_Matrix_dimension_mismatch"));
                    return false;
                }
                for (int j = 0; j < m; ++j) {
                    String number = line_tok.nextToken();
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(number);
                    }
                    catch (NumberFormatException e) {
                        this.log(JAMS.i18n((String)"Cant_read_Linear_Constraint_Matrix_because_there_are_unparseable_elements") + ":" + e.toString());
                        return false;
                    }
                    this.LinearConstraints_A.set(i, j, value);
                }
            }
            tok = new StringTokenizer(this.linearConstraintVectorB, ";");
            this.LinearConstraints_b = new Matrix(n, 1);
            n = tok.countTokens();
            for (i = 0; i < n; ++i) {
                String number = tok.nextToken();
                double value = 0.0;
                try {
                    value = Double.parseDouble(number);
                }
                catch (NumberFormatException e) {
                    this.log(JAMS.i18n((String)"Cant_read_Linear_Constraint_Matrix_because_there_are_unparseable_elements") + ":" + e.toString());
                }
                this.LinearConstraints_b.set(i, 0, value);
            }
        }
        if (this.LinearConstraints_A != null && this.LinearConstraints_b != null) {
            if (this.LinearConstraints_A.getRowDimension() != this.LinearConstraints_b.getRowDimension()) {
                this.log(JAMS.i18n((String)"LinearConstraintMatrixA_must_have_the_same_number_of_rows_as_LinearConstraintVectorB"));
                return false;
            }
            if (this.LinearConstraints_A.getColumnDimension() != this.n) {
                this.log(JAMS.i18n((String)"LinearConstraintMatrixA_must_have_the_same_number_of_columns_as_there_are_parameters"));
                return false;
            }
        }
        if (this.x0 == null) {
            this.x0 = new double[][]{this.randomSampler()};
        }
        if (this.complexesCount <= 0.0) {
            this.log("warning: NumberOfComplexes_value_not_specified, set to default of 2");
            this.complexesCount = 2.0;
        }
        if (this.pcento <= 0.0) {
            this.log("warning: pcento_value_not_specified, set to default of 0.1");
            this.pcento = 0.1;
        }
        if (this.peps <= 0.0) {
            this.log("warning: peps_value_not_specified, set to default of 0.00001");
            this.peps = 1.0E-5;
        }
        if (this.kstop <= 0.0) {
            this.log("warning: kstop_value_not_specified, set to default of 10");
            this.kstop = 10.0;
        }
        if (this.parallelExecution) {
            this.pseq = new ParallelSequence(this);
            this.pseq.setExcludeFiles(this.excludeFiles);
            this.pseq.setThreadCount((int)this.threadCount);
        }
        return true;
    }

    private double NormalizedgeometricRange(SampleFactory.SampleSO[] x, double[] bound) {
        if (x.length == 0) {
            return 0.0;
        }
        double mean = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                min = Math.min(min, x[j].x[i]);
                max = Math.max(max, x[j].x[i]);
            }
            mean += (max - min) / bound[i];
        }
        return mean /= (double)this.n;
    }

    private int find(int[] lcs, int startindex, int endindex, int value) {
        for (int i = startindex; i < endindex; ++i) {
            if (lcs[i] != value) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SampleFactory.SampleSO cceua2(SampleFactory.SampleSO[] s, double[] bl, double[] bu) throws SampleLimitException, ObjectiveAchievedException {
        int i;
        int nps = s.length;
        int nopt = s[0].x.length;
        int n = nps;
        int m = nopt;
        double alpha = 1.0;
        double beta = 0.5;
        SampleFactory.SampleSO sw = s[n - 1];
        double[] ce = new double[nopt];
        int i2 = 0;
        while (i2 < nopt) {
            ce[i2] = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                int n2 = i2;
                ce[n2] = ce[n2] + s[j].x[i2];
            }
            int n3 = i2++;
            ce[n3] = ce[n3] / (double)(n - 1);
        }
        double[] snew1 = new double[nopt];
        double[] snew2 = new double[nopt];
        double[] snew3 = new double[nopt];
        for (int i3 = 0; i3 < nopt; ++i3) {
            snew1[i3] = ce[i3] + alpha * (ce[i3] - sw.x[i3]);
        }
        int ibound = 0;
        for (i = 0; i < nopt; ++i) {
            if (snew1[i] - bl[i] < 0.0) {
                ibound = 1;
            }
            if (!(bu[i] - snew1[i] < 0.0)) continue;
            ibound = 2;
        }
        if (ibound >= 1) {
            snew1 = this.randomSampler();
        }
        for (i = 0; i < nopt; ++i) {
            snew2[i] = sw.x[i] + beta * (ce[i] - s[n - 1].x[i]);
        }
        snew3 = this.randomSampler();
        if (this.parallelExecution) {
            double[][] x_pseq = new double[][]{snew1, snew2, snew3};
            ParallelSequence.OutputData result = this.pseq.procedure(x_pseq);
            if (this.collection == null) {
                this.collection = result.dc;
            } else {
                DataCollection dataCollection = this.collection;
                synchronized (dataCollection) {
                    if (result.dc != null) {
                        this.collection.mergeDataCollections(result.dc);
                    }
                }
            }
            if (result.list.get(0).F()[0] <= result.list.get(1).F()[0] && result.list.get(0).F()[0] <= result.list.get(2).F()[0]) {
                return this.factory.getSampleSO(result.list.get((int)0).x, result.list.get(0).F()[0]);
            }
            if (result.list.get(1).F()[0] <= result.list.get(0).F()[0] && result.list.get(1).F()[0] <= result.list.get(2).F()[0]) {
                return this.factory.getSampleSO(result.list.get((int)1).x, result.list.get(1).F()[0]);
            }
            return this.factory.getSampleSO(result.list.get((int)2).x, result.list.get(2).F()[0]);
        }
        SampleFactory.SampleSO x0 = this.getSampleSO(snew1);
        SampleFactory.SampleSO x1 = this.getSampleSO(snew2);
        SampleFactory.SampleSO x2 = this.getSampleSO(snew3);
        if (x0.F()[0] <= x1.F()[0] && x0.F()[0] <= x2.F()[0]) {
            return x0;
        }
        if (x1.F()[0] <= x0.F()[0] && x1.F()[0] <= x2.F()[0]) {
            return x1;
        }
        return x2;
    }

    private SampleFactory.SampleSO cceua(SampleFactory.SampleSO[] simplex, double[] bl, double[] bu) throws SampleLimitException, ObjectiveAchievedException {
        Matrix A = new Matrix(bl.length + bu.length, this.n);
        Matrix b = new Matrix(bl.length + bu.length, 1);
        for (int i = 0; i < bl.length; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i == j) {
                    A.set(i, j, -1.0);
                    A.set(i + this.n, j, 1.0);
                    continue;
                }
                A.set(i, j, 0.0);
                A.set(i + this.n, j, 0.0);
            }
            b.set(i, 0, -bl[i]);
            b.set(i + this.n, 0, bu[i]);
        }
        return this.SearchMethod.step(this, simplex, A, b, this.lowBound, this.upBound);
    }

    private void EvolveSubPopulation(int nspl, int nps, int npg, int nopt, SampleFactory.SampleSO[] c, double[] bu, double[] bl) {
        for (int loop = 0; loop < nspl; ++loop) {
            int i;
            int[] lcs = new int[nps];
            lcs[0] = 0;
            for (int k3 = 1; k3 < nps; ++k3) {
                int idx;
                int lpos = 0;
                for (int iter = 0; iter < 1000 && (idx = this.find(lcs, 0, k3, lpos = (int)Math.floor((double)npg + 0.5 - Math.sqrt(((double)npg + 0.5) * ((double)npg + 0.5) - (double)(npg * (npg + 1)) * this.randomValue())))) != -1; ++iter) {
                }
                lcs[k3] = lpos;
            }
            Arrays.sort(lcs);
            SampleFactory.SampleSO[] s = new SampleFactory.SampleSO[nps];
            for (i = 0; i < nps; ++i) {
                s[i] = c[lcs[i]].clone();
            }
            try {
                s[nps - 1] = this.cceua2(s, bl, bu);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            for (i = 0; i < nps; ++i) {
                c[lcs[i]] = s[i];
            }
            Arrays.sort(c, new SampleFactory.SampleSOComperator(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleFactory.SampleSO sceua(double[][] x0, double[] bl, double[] bu, int maxn, int kstop, double pcento, double peps, int ngs, int iseed) {
        SampleFactory.SampleSO[] x;
        int i;
        double[] bound;
        int npt;
        int nspl;
        int nps;
        int npg;
        int nopt;
        block34: {
            int method = 1;
            this.SearchMethod = null;
            if (method == 1) {
                this.SearchMethod = new NelderMead();
            } else if (method == 2) {
                this.SearchMethod = new ImplicitFiltering();
            } else if (method == 3) {
                this.SearchMethod = new MDS();
            }
            nopt = bl.length;
            npg = 2 * nopt + 1;
            nps = nopt + 1;
            nspl = npg;
            npt = npg * ngs;
            bound = new double[nopt];
            for (i = 0; i < nopt; ++i) {
                bound[i] = bu[i] - bl[i];
            }
            i = 0;
            x = new SampleFactory.SampleSO[npt];
            try {
                double[][] initParameter = new double[npt][];
                for (i = 0; i < npt; ++i) {
                    initParameter[i] = this.x0 != null && this.x0.length > i ? (double[])this.x0[i].clone() : this.randomSampler();
                }
                if (!this.parallelExecution) {
                    for (i = 0; i < npt; ++i) {
                        x[i] = this.getSampleSO(initParameter[i]);
                    }
                    break block34;
                }
                ParallelSequence.OutputData result = this.pseq.procedure(initParameter);
                for (int j = 0; j < initParameter.length; ++j) {
                    try {
                        x[j] = this.factory.getSampleSO(result.list.get((int)j).x, result.list.get(j).F()[0]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        System.out.println("For an unknown reason parallel sampling did not succeed completly .. switching to sequential execution");
                        for (int k = j; k < initParameter.length; ++k) {
                            x[k] = this.getSampleSO(initParameter[k]);
                        }
                        j = initParameter.length;
                        break;
                    }
                }
                if (this.collection == null) {
                    this.collection = result.dc;
                    break block34;
                }
                DataCollection dataCollection = this.collection;
                synchronized (dataCollection) {
                    this.collection.mergeDataCollections(result.dc);
                    this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), true);
                }
            }
            catch (SampleLimitException e) {
                System.out.println("Sample Limit Reached: " + e);
                return x[i];
            }
            catch (Exception e) {
                e.printStackTrace();
                return x[i];
            }
        }
        int nloop = 0;
        Arrays.sort(x, new SampleFactory.SampleSOComperator(false));
        double gnrng = this.NormalizedgeometricRange(x, bound);
        this.log(JAMS.i18n((String)"The_Inital_Loop_0"));
        this.log(JAMS.i18n((String)"Best") + x[0].toString());
        this.log(JAMS.i18n((String)"Worst") + x[npt - 1].toString());
        if (gnrng < peps) {
            this.log(JAMS.i18n((String)"THE_POPULATION_HAS_CONVERGED_TO_A_PRESPECIFIED_SMALL_PARAMETER_SPACE"));
        }
        nloop = 0;
        double[] criter = new double[kstop];
        double criter_change = 100000.0;
        while (criter_change > pcento) {
            ++nloop;
            ArrayList<SampleFactory.SampleSO[]> complexes = new ArrayList<SampleFactory.SampleSO[]>();
            ArrayList<int[]> k1list = new ArrayList<int[]>();
            ArrayList<int[]> k2list = new ArrayList<int[]>();
            ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(64);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(ngs, ngs, 30L, TimeUnit.SECONDS, workQueue);
            for (int igs = 0; igs < ngs; ++igs) {
                int[] k1 = new int[npg];
                int[] k2 = new int[npg];
                for (i = 0; i < npg; ++i) {
                    k1[i] = i;
                    k2[i] = k1[i] * ngs + igs;
                }
                SampleFactory.SampleSO[] c = new SampleFactory.SampleSO[npg];
                for (i = 0; i < npg; ++i) {
                    c[k1[i]] = x[k2[i]].clone();
                }
                complexes.add(c);
                k1list.add(k1);
                k2list.add(k2);
                if (this.parallelExecution) {
                    InputData param = new InputData(this, nspl, npg, npg, nopt, c, x, k1, k2, bu, bl);
                    ParamRunnable<InputData> r = new ParamRunnable<InputData>(param){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SCE sCE = SCE.this;
                            synchronized (sCE) {
                                SCE.this.EvolveSubPopulation(((InputData)this.in).nspl, ((InputData)this.in).nps, ((InputData)this.in).npg, ((InputData)this.in).nopt, ((InputData)this.in).c, ((InputData)this.in).bu, ((InputData)this.in).bl);
                            }
                            for (int i = 0; i < ((InputData)this.in).npg; ++i) {
                                ((InputData)this.in).x[((InputData)this.in).k2[i]] = ((InputData)this.in).c[((InputData)this.in).k1[i]];
                            }
                        }
                    };
                    threadPool.execute(r);
                    continue;
                }
                this.EvolveSubPopulation(nspl, nps, npg, nopt, c, bu, bl);
                for (int j = 0; j < npg; ++j) {
                    x[k2[j]] = c[k1[j]];
                }
            }
            if (this.parallelExecution) {
                threadPool.shutdown();
                try {
                    threadPool.awaitTermination(100L, TimeUnit.HOURS);
                }
                catch (InterruptedException ie) {
                    System.out.println("Serious problem with thread pool .. was interrupted");
                    ie.printStackTrace();
                }
            }
            Arrays.sort(x, new SampleFactory.SampleSOComperator(false));
            gnrng = this.NormalizedgeometricRange(x, bound);
            this.log(JAMS.i18n((String)"Evolution_Loop") + ":" + nloop + JAMS.i18n((String)"Trial") + " " + this.getIterationCounter());
            this.log(JAMS.i18n((String)"Best") + x[0]);
            this.log(JAMS.i18n((String)"Worst") + x[x.length - 1]);
            if (gnrng < peps) {
                this.log(JAMS.i18n((String)"THE_POPULATION_HAS_CONVERGED_TO_A_PRESPECIFIED_SMALL_PARAMETER_SPACE"));
            }
            if ((double)this.getIterationCounter() > this.maxn) break;
            for (i = 0; i < kstop - 1; ++i) {
                criter[i] = criter[i + 1];
            }
            criter[kstop - 1] = x[0].f();
            if (nloop < kstop) continue;
            criter_change = Math.abs(criter[0] - criter[kstop - 1]) * 100.0;
            double criter_mean = 0.0;
            for (i = 0; i < kstop; ++i) {
                criter_mean += Math.abs(criter[i]);
            }
            if (!((criter_change /= (criter_mean /= (double)kstop)) < pcento)) continue;
            this.log(JAMS.i18n((String)"THE_BEST_POINT_HAS_IMPROVED_IN_LAST") + " " + kstop + " " + JAMS.i18n((String)"LOOPS_BY"));
            this.log(JAMS.i18n((String)"LESS_THAN_THE_THRESHOLD") + " " + pcento + "%");
            this.log(JAMS.i18n((String)"CONVERGENCY_HAS_ACHIEVED_BASED_ON_OBJECTIVE_FUNCTION_CRITERIA"));
        }
        this.log(JAMS.i18n((String)"SEARCH_WAS_STOPPED_AT_TRIAL_NUMBER") + " " + this.getIterationCounter());
        this.log(JAMS.i18n((String)"NORMALIZED_GEOMETRIC_RANGE") + " " + gnrng);
        this.log(JAMS.i18n((String)"THE_BEST_POINT_HAS_IMPROVED_IN_LAST") + kstop + " " + JAMS.i18n((String)"LOOPS_BY") + " " + criter_change + "%");
        if (this.collection != null) {
            this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), false);
        }
        return x[0];
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        this.sceua(this.x0, this.lowBound, this.upBound, (int)this.getMaxn(), (int)this.kstop, this.pcento, this.peps, (int)this.complexesCount, 10);
    }

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(SCE.class.getSimpleName(), SCE.class.getName(), 6, false);
        desc.addParameter(new NumericOptimizerParameter("complexesCount", JAMS.i18n((String)"number_of_complexes"), 2.0, 1.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("pcento", JAMS.i18n((String)"worst_acceptable_improvement"), 0.05, 1.0E-6, 1.0));
        desc.addParameter(new NumericOptimizerParameter("peps", JAMS.i18n((String)"minimal_geometric_population"), 1.0E-5, 1.0E-6, 1.0));
        desc.addParameter(new NumericOptimizerParameter("kstop", JAMS.i18n((String)"kStop"), 10.0, 1.0, 100.0));
        desc.addParameter(new BooleanOptimizerParameter("parallelExecution", JAMS.i18n((String)"parallelExecution"), false));
        desc.addParameter(new NumericOptimizerParameter("threadCount", JAMS.i18n((String)"threadCount"), 12.0, 1.0, 20.0));
        desc.addParameter(new StringOptimizerParameter("excludeFiles", JAMS.i18n((String)"exclude_files_list"), "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log"));
        return desc;
    }

    private static abstract class ParamRunnable<Y>
    implements Runnable {
        Y in;

        ParamRunnable(Y d) {
            this.in = d;
        }
    }

    public static class InputData
    implements Serializable {
        public SCE context;
        int nspl;
        int nps;
        int npg;
        int nopt;
        double[] bu;
        double[] bl;
        SampleFactory.SampleSO[] c;
        SampleFactory.SampleSO[] x;
        int[] k1;
        int[] k2;

        public InputData(SCE context, int nspl, int nps, int npg, int nopt, SampleFactory.SampleSO[] c, SampleFactory.SampleSO[] x, int[] k1, int[] k2, double[] bu, double[] bl) {
            this.context = context;
            this.nspl = nspl;
            this.nps = nps;
            this.npg = npg;
            this.nopt = nopt;
            this.bu = bu;
            this.bl = bl;
            this.x = x;
            this.c = c;
            this.k1 = k1;
            this.k2 = k2;
        }
    }
}

