/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import jams.io.SerializableBufferedWriter;
import jams.model.JAMSComponentDescription;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="NelderMead", author="Christian Fischer", description="Performs a nelder mead optimization. Advantage: Derivative free optimization method. Disadvantage: only local convergence")
public class NelderMead
extends Optimizer {
    SerializableBufferedWriter writer = null;
    public SampleFactory.SampleSO[] initialSimplex = null;
    public double epsilon = 0.01;
    public double max_restart_count = 5.0;

    public void sort(SampleFactory.SampleSO[] array) {
        Arrays.sort(array, new SampleFactory.SampleSOComperator(false));
    }

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(NelderMead.class.getSimpleName(), NelderMead.class.getName(), 250, false);
        desc.addParameter(new NumericOptimizerParameter("max_restart_count", JAMS.i18n((String)"Number_of_restarts"), 5.0, 0.0, 1000.0));
        desc.addParameter(new NumericOptimizerParameter("epsilon", JAMS.i18n((String)"stopping_criterion_minimal_geometric_range"), 0.01, 0.0, 1.0));
        return desc;
    }

    public double NormalizedgeometricRange(SampleFactory.SampleSO[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double[] min = new double[this.n];
        double[] max = new double[this.n];
        double mean = 0.0;
        for (int i = 0; i < this.n; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                min[i] = Math.min(x[j].x[i], min[i]);
                max[i] = Math.max(x[j].x[i], max[i]);
            }
            mean += Math.log(max[i] - min[i]);
        }
        return Math.exp(mean /= (double)this.n);
    }

    public boolean feasible(double[] point) {
        for (int i = 0; i < point.length; ++i) {
            if (!(point[i] < this.lowBound[i]) && !(point[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        boolean stop = false;
        generator.setSeed(0L);
        SampleFactory.SampleSO[] simplex = new SampleFactory.SampleSO[this.n + 1];
        if (this.initialSimplex != null) {
            simplex = this.initialSimplex;
        } else {
            for (int i = 0; i < this.n + 1; ++i) {
                simplex[i] = this.x0 != null && i < this.x0.length ? this.getSampleSO(this.x0[i]) : this.getSampleSO(this.randomSampler());
            }
        }
        int m = simplex.length;
        double alpha = 1.0;
        double gamma = 2.0;
        double rho = 0.5;
        double sigma = 0.5;
        int restart_counter = 0;
        while (!stop) {
            int i;
            if ((double)this.factory.getSize() > this.getMaxn()) {
                this.log("*********************************************************");
                this.log(JAMS.i18n((String)"Maximum_number_of_iterations_reached_finished_optimization"));
                this.log(JAMS.i18n((String)"bestpoint") + simplex[0]);
                this.log("*********************************************************");
                return;
            }
            if (this.NormalizedgeometricRange(simplex) < this.getEpsilon()) {
                ++restart_counter;
                if (this.getMax_restart_count() < (double)restart_counter) {
                    this.log("*********************************************************");
                    this.log(JAMS.i18n((String)"Maximum_number_of_restarts_reached_finished_optimization"));
                    this.log(JAMS.i18n((String)"bestpoint") + simplex[0]);
                    this.log("*********************************************************");
                    return;
                }
                this.log(JAMS.i18n((String)"restart"));
                for (int i2 = 1; i2 < m; ++i2) {
                    simplex[i2] = this.getSampleSO(this.randomSampler());
                }
            }
            this.sort(simplex);
            double[] centroid = new double[this.n];
            for (int j = 0; j < this.n; ++j) {
                centroid[j] = 0.0;
                for (i = 0; i < m - 1; ++i) {
                    int n = j;
                    centroid[n] = centroid[n] + simplex[i].x[j] * (1.0 / ((double)m - 1.0));
                }
            }
            double[] reflection = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                reflection[i] = centroid[i] + alpha * (centroid[i] - simplex[m - 1].x[i]);
            }
            SampleFactory.SampleSO reflection_SampleSO = null;
            if (this.feasible(reflection)) {
                this.log(JAMS.i18n((String)"reflection_step"));
                reflection_SampleSO = this.getSampleSO(reflection);
                if (simplex[0].f() < reflection_SampleSO.f() && reflection_SampleSO.f() < simplex[m - 1].f()) {
                    simplex[m - 1] = reflection_SampleSO;
                    continue;
                }
            }
            if (this.feasible(reflection) && simplex[0].f() >= reflection_SampleSO.f()) {
                double[] expansion = new double[this.n];
                for (int i3 = 0; i3 < this.n; ++i3) {
                    expansion[i3] = centroid[i3] + gamma * (centroid[i3] - simplex[m - 1].x[i3]);
                }
                this.log(JAMS.i18n((String)"expansion_step"));
                SampleFactory.SampleSO expansion_SampleSO = this.getSampleSO(expansion);
                if (this.feasible(expansion) && expansion_SampleSO.f() < reflection_SampleSO.f()) {
                    simplex[m - 1] = expansion_SampleSO;
                    continue;
                }
                simplex[m - 1] = reflection_SampleSO;
                continue;
            }
            if (!this.feasible(reflection) || simplex[m - 1].f() <= reflection_SampleSO.f()) {
                double[] contraction = new double[this.n];
                for (int i4 = 0; i4 < this.n; ++i4) {
                    contraction[i4] = centroid[i4] + rho * (centroid[i4] - simplex[m - 1].x[i4]);
                }
                this.log(JAMS.i18n((String)"contraction_step"));
                SampleFactory.SampleSO contraction_SampleSO = null;
                if (!this.feasible(contraction)) {
                    this.log(JAMS.i18n((String)"not_feasible_after_contraction_step"));
                    contraction_SampleSO = this.getSampleSO(this.randomSampler());
                } else {
                    contraction_SampleSO = this.getSampleSO(contraction);
                }
                if (contraction_SampleSO.f() < simplex[m - 1].f()) {
                    simplex[m - 1] = contraction_SampleSO;
                    continue;
                }
            }
            for (int i5 = 1; i5 < m; ++i5) {
                double[] shrink = new double[this.n];
                for (int j = 0; j < this.n; ++j) {
                    shrink[j] = simplex[0].x[j] + sigma * (simplex[i5].x[j] - simplex[0].x[j]);
                }
                this.log(JAMS.i18n((String)"shrink_step"));
                simplex[i5] = this.getSampleSO(shrink);
            }
        }
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getMax_restart_count() {
        return this.max_restart_count;
    }

    public void setMax_restart_count(double max_restart_count) {
        this.max_restart_count = max_restart_count;
    }
}

