/*
 * Decompiled with CFR 0.152.
 */
package optas.io;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import optas.data.DataSet;
import optas.data.TimeSerie;
import optas.gui.wizard.OPTASWizardException;

public class TSDataReader {
    public static final String SEPARATOR = "\t";
    public File dataFileName;
    Attribute.Calendar startTime = null;
    Attribute.Calendar endTime = null;
    private JAMSTableDataStore store;
    private TimeSerie t;
    private double missingDataValue = -9999.0;
    private String missingDataString = "-9999";
    private String projection = "unknown";
    private String x = "x";
    private String y = "y";
    String[] name = null;
    double[] id = null;
    double[] statx = null;
    double[] staty = null;
    double[] statelev = null;
    String tres = null;
    int headerLineCount = 0;
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd\tHH:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    protected SimpleDateFormat format2 = new SimpleDateFormat("dd.MM.yyyy\tHH:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };

    public TSDataReader(File data) throws IOException {
        this.dataFileName = data;
        this.init();
    }

    public int getColumnCount() {
        return this.statx.length;
    }

    public ArrayList<Object> getNames() {
        ArrayList<Object> attr = new ArrayList<Object>();
        for (int i = 0; i < this.name.length; ++i) {
            attr.add(this.name[i]);
        }
        return attr;
    }

    public void setElevation(double[] elev) {
        for (int i = 0; i < elev.length; ++i) {
            this.statelev[i] = elev[i];
        }
    }

    public int getTimeUnit() {
        if (this.tres == null) {
            return -1;
        }
        if (this.tres.compareTo("d") == 0) {
            return 6;
        }
        if (this.tres.compareTo("h") == 0) {
            return 11;
        }
        if (this.tres.compareTo("m") == 0) {
            return 2;
        }
        return -1;
    }

    public double getMissingDataValue() {
        return this.missingDataValue;
    }

    public String getMissingDataString() {
        return this.missingDataString;
    }

    private String cleanToken(String token) {
        while (token.endsWith(" ") || token.endsWith(SEPARATOR)) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() throws IOException {
        String dataName = null;
        String start = null;
        String end = null;
        String line = "#";
        BufferedReader reader = new BufferedReader(new FileReader(this.dataFileName));
        while (line.length() == 0 || line.charAt(0) == '#') {
            if (line.contains("@dataValueAttribs")) {
                line = "@dataValueAttribs";
                break;
            }
            line = reader.readLine();
            ++this.headerLineCount;
        }
        boolean dataValueAttribsValid = false;
        boolean datasetAttribsValid = false;
        boolean statAttribsValid = false;
        StringTokenizer strTok = new StringTokenizer(line, SEPARATOR);
        String token = this.cleanToken(strTok.nextToken());
        try {
            while (line != null && token != null && !token.equalsIgnoreCase("@dataVal")) {
                String desc;
                int i;
                block50: {
                    if (token.equals("@dataValueAttribs")) {
                        line = reader.readLine();
                        ++this.headerLineCount;
                        strTok = new StringTokenizer(line, SEPARATOR);
                        dataName = strTok.nextToken();
                        double lowBound = Double.parseDouble(strTok.nextToken());
                        double uppBound = Double.parseDouble(strTok.nextToken());
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, SEPARATOR);
                        token = this.cleanToken(strTok.nextToken());
                        dataValueAttribsValid = true;
                        ++this.headerLineCount;
                        continue;
                    }
                    if (token.equalsIgnoreCase("@dataSetAttribs")) {
                        line = reader.readLine();
                    } else if (token.equalsIgnoreCase("@statAttribVal")) {
                        line = reader.readLine();
                        break block50;
                    } else {
                        if (strTok.hasMoreElements()) {
                            token = strTok.nextToken();
                            continue;
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, SEPARATOR);
                        token = strTok.nextToken();
                        continue;
                    }
                    for (i = 0; i < 4; ++i) {
                        ++this.headerLineCount;
                        strTok = new StringTokenizer(line, "\t ");
                        desc = this.cleanToken(strTok.nextToken());
                        if (desc.equalsIgnoreCase("missingDataVal")) {
                            this.missingDataString = strTok.nextToken();
                            this.missingDataValue = Double.parseDouble(this.cleanToken(this.missingDataString));
                        } else if (desc.equalsIgnoreCase("dataStart")) {
                            start = this.cleanToken(strTok.nextToken());
                            if (strTok.hasMoreTokens()) {
                                start = start + " " + this.cleanToken(strTok.nextToken());
                            }
                        } else if (desc.equalsIgnoreCase("dataEnd")) {
                            end = this.cleanToken(strTok.nextToken());
                            if (strTok.hasMoreTokens()) {
                                end = end + " " + this.cleanToken(strTok.nextToken());
                            }
                        } else if (desc.equalsIgnoreCase("tres")) {
                            this.tres = this.cleanToken(strTok.nextToken());
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, SEPARATOR);
                        token = this.cleanToken(strTok.nextToken());
                    }
                    datasetAttribsValid = true;
                    continue;
                }
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++this.headerLineCount;
                    strTok = new StringTokenizer(line, SEPARATOR);
                    desc = this.cleanToken(strTok.nextToken());
                    int nstat = strTok.countTokens();
                    if (desc.equalsIgnoreCase("name")) {
                        this.name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            this.name[j] = this.cleanToken(strTok.nextToken());
                        }
                    } else if (desc.equalsIgnoreCase("id")) {
                        this.id = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            this.id[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("elevation")) {
                        this.statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            this.statelev[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("x")) {
                        this.statx = new double[nstat];
                        this.x = "x";
                        for (j = 0; j < nstat; ++j) {
                            this.statx[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("lat")) {
                        this.statx = new double[nstat];
                        this.x = "lat";
                        for (j = 0; j < nstat; ++j) {
                            this.statx[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("y")) {
                        this.staty = new double[nstat];
                        this.y = "y";
                        for (j = 0; j < nstat; ++j) {
                            this.staty[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("lon")) {
                        this.staty = new double[nstat];
                        this.y = "lon";
                        for (j = 0; j < nstat; ++j) {
                            this.staty[j] = Double.parseDouble(this.cleanToken(strTok.nextToken()));
                        }
                    } else if (desc.equalsIgnoreCase("datacolumn")) {
                        ++this.headerLineCount;
                        ++this.headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, SEPARATOR);
                    token = this.cleanToken(strTok.nextToken());
                    statAttribsValid = true;
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException(JAMS.i18n((String)"not_a_valid_line_in_J2K_datafile "));
        }
        catch (NoSuchElementException nfe) {
            nfe.printStackTrace();
            throw new IOException(JAMS.i18n((String)"not_a_valid_line_in_J2K_datafile "));
        }
        catch (NullPointerException npe) {
            throw new IOException(JAMS.i18n((String)"not_a_valid_J2K_datafile "));
        }
        finally {
            reader.close();
        }
        if (dataValueAttribsValid && datasetAttribsValid && statAttribsValid) {
            this.startTime = TSDataReader.parseJ2KTime(start);
            this.endTime = TSDataReader.parseJ2KTime(end);
            return;
        }
        throw new IOException(JAMS.i18n((String)"no_valid_J2K_datafile"));
    }

    protected int getHeaderLineCount() {
        return this.headerLineCount;
    }

    public TimeSerie getData(int column) throws OPTASWizardException {
        this.store = new GenericDataReader(this.dataFileName.getAbsolutePath(), false, this.headerLineCount + 1);
        ArrayList<Double> doubleArray = new ArrayList<Double>();
        int firstColumn = -1;
        while (this.store.hasNext()) {
            JAMSTableDataArray tableData = this.store.getNext();
            try {
                if (firstColumn == -1) {
                    boolean didWork = false;
                    while (!didWork) {
                        try {
                            doubleArray.add(Double.parseDouble(tableData.getValues()[firstColumn + column]));
                            didWork = true;
                        }
                        catch (Throwable e) {
                            if (++firstColumn < tableData.getValues().length) continue;
                            throw new OPTASWizardException("J2K input file cannot be read! Invalid format!");
                        }
                    }
                    continue;
                }
                doubleArray.add(Double.parseDouble(tableData.getValues()[firstColumn + column]));
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                doubleArray.add(JAMS.getMissingDataValue());
            }
        }
        double[] data = new double[doubleArray.size()];
        for (int i = 0; i < doubleArray.size(); ++i) {
            data[i] = (Double)doubleArray.get(i) == this.missingDataValue ? JAMS.getMissingDataValue() : (Double)doubleArray.get(i);
        }
        Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
        interval.setStart(this.startTime);
        interval.setEnd(this.endTime);
        if (this.tres.compareTo("m") == 0) {
            interval.setTimeUnit(2);
            interval.setTimeUnitCount(1);
        }
        if (this.tres.compareTo("d") == 0) {
            interval.setTimeUnit(6);
            interval.setTimeUnitCount(1);
        }
        if (this.tres.compareTo("h") == 0) {
            interval.setTimeUnit(11);
            interval.setTimeUnitCount(1);
        }
        try {
            this.t = new TimeSerie(data, interval, "observation", null);
        }
        catch (DataSet.MismatchException m) {
            m.printStackTrace();
            throw new OPTASWizardException("J2K input file is not valid!\n" + m.toString());
        }
        this.store.close();
        return this.t;
    }

    public double[] getLocation(int i) {
        return new double[]{this.statx[i], this.staty[i]};
    }

    public void setLocation(int i, double[] loc) {
        this.statx[i] = loc[0];
        this.staty[i] = loc[1];
    }

    public void setStartTime(Date d) {
        this.startTime.setTime(d);
    }

    public void setEndTime(Date d) {
        this.endTime.setTime(d);
    }

    public void setProjection(String proj, String x, String y) {
        this.projection = proj;
        this.x = x;
        this.y = y;
    }

    private static Attribute.Calendar parseJ2KTime(String timeString) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        sdf1.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf2.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = null;
        try {
            d = sdf1.parse(timeString);
        }
        catch (ParseException pe) {
            try {
                d = sdf2.parse(timeString);
            }
            catch (ParseException pe2) {
                return null;
            }
        }
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        cal.setTime(d);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target) throws IOException {
        StringBuilder content = new StringBuilder();
        BufferedWriter writer = null;
        try {
            Date firstDate = null;
            Date lastDate = null;
            this.store = new GenericDataReader(this.dataFileName.getAbsolutePath(), true, this.headerLineCount + 1);
            while (this.store.hasNext()) {
                JAMSTableDataArray dataset = this.store.getNext();
                content.append("\n");
                lastDate = dataset.getTime().getTime();
                content.append(this.format.format(lastDate));
                if (firstDate == null) {
                    firstDate = lastDate;
                }
                for (String s : dataset.getValues()) {
                    if (s.contains(":")) continue;
                    content.append(SEPARATOR + s);
                }
            }
            this.setStartTime(firstDate);
            this.setEndTime(lastDate);
            String header = this.buildHeader();
            writer = new BufferedWriter(new FileWriter(target));
            writer.write(header);
            writer.write(content.substring(0));
        }
        finally {
            this.store.close();
            writer.close();
        }
    }

    public String buildHeader() {
        String header = "#created by TSDataReader - projection is " + this.projection + "\n";
        header = header + "@dataValueAttribs\ndata\t0.0\t0.0\t?\n";
        header = header + "@dataSetAttribs\nmissingDataVal\t-9999\n";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (this.startTime != null) {
            calendar.setTime(this.startTime.getTime());
            header = header + "dataStart\t" + this.format2.format(calendar.getTime()) + "\n";
            calendar.setTime(this.endTime.getTime());
            calendar.setTime(this.endTime.getTime());
            header = header + "dataEnd\t" + this.format2.format(calendar.getTime()) + "\n";
        } else {
            header = header + "dataStart\t" + this.startTime + "\n";
            header = header + "dataEnd\t" + this.endTime + "\n";
        }
        header = header + "tres\td\n";
        header = header + "@statAttribVal\n";
        String strStation = "name\t";
        String strID = "ID\t";
        String strElevation = "elevation\t";
        String strX = this.x + SEPARATOR;
        String strY = this.y + SEPARATOR;
        String strDataColumn = "datacolumn\t";
        for (int i = 0; i < this.name.length; ++i) {
            strStation = strStation + this.name[i];
            strID = strID + this.id[i];
            strElevation = strElevation + this.statelev[i];
            strX = strX + this.statx[i];
            strY = strY + this.staty[i];
            strDataColumn = strDataColumn + (i + 1);
            if (i == this.name.length) continue;
            strStation = strStation + SEPARATOR;
            strID = strID + SEPARATOR;
            strElevation = strElevation + SEPARATOR;
            strY = strY + SEPARATOR;
            strX = strX + SEPARATOR;
            strDataColumn = strDataColumn + SEPARATOR;
        }
        header = header + strStation + "\n" + strID + "\n" + strElevation + "\n" + strX + "\n" + strY + "\n" + strDataColumn + "\n";
        header = header + "@dataVal";
        return header;
    }
}

