/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.gui;

import java.util.ArrayList;
import optas.data.DataSet;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.DottyPlot;
import optas.gui.MCAT5.MCAT5Plot;
import optas.hydro.calculations.SlopeCalculations;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SimpleGlobalSensitivity
extends DottyPlot {
    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble p1 = (SimpleEnsemble)p[0].get(0);
        SimpleEnsemble p2 = (SimpleEnsemble)p[1].get(0);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(p1.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis("slope"));
        XYSeries[] dataset = SlopeCalculations.calculateDerivative((EfficiencyEnsemble)p2, this.getDataSource());
        int c = -1;
        for (int i = 0; i < dataset.length; ++i) {
            if (!dataset[i].getDescription().equals(p1.getName())) continue;
            c = i;
            break;
        }
        if (c == -1) {
            return;
        }
        this.plot.setDataset(0, (XYDataset)new XYSeriesCollection(dataset[c]));
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
    }
}

