/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.util.ArrayList;
import java.util.TreeSet;
import optas.SA.SobolsMethodTemporal;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.hydro.OptimizationScheme;
import optas.hydro.ParameterGroup;

public class VarianceBasedGreedyOptimizationScheme
extends OptimizationScheme {
    SobolsMethodTemporal VBTSA;
    double tau = 0.7;
    double minDominatedTimesteps = 0.2;

    @Override
    public String toString() {
        return "Greedy";
    }

    public void setData(SobolsMethodTemporal VBTSA, SimpleEnsemble[] p, EfficiencyEnsemble eff, TimeSerie ts) {
        this.n = p.length;
        this.T = ts.getTimesteps();
        this.VBTSA = VBTSA;
        this.parameter = p;
        this.ts = ts;
    }

    @Override
    public void update() {
        this.dominatedTimeStepsForGroup.clear();
        double[] varianceExplainedCurrent = new double[this.T];
        for (int i = 0; i < this.solutionGroups.size(); ++i) {
            ParameterGroup p = (ParameterGroup)this.solutionGroups.get(i);
            ArrayList<Integer> timeStepsTmp = new ArrayList<Integer>();
            TreeSet<Integer> groupSet = new TreeSet<Integer>();
            for (int j = 0; j < p.getSize(); ++j) {
                groupSet.add(p.get(j));
            }
            double[][] varianceExplainedUpdate = this.VBTSA.calcSensitivity(groupSet);
            for (int t = 0; t < this.T; ++t) {
                double vt = varianceExplainedUpdate[t][1];
                double critValue = this.tau + (1.0 - this.tau) * varianceExplainedCurrent[t];
                if (!(vt > critValue)) continue;
                timeStepsTmp.add(t);
            }
            int[] timeSteps = new int[timeStepsTmp.size()];
            for (int k = 0; k < timeStepsTmp.size(); ++k) {
                timeSteps[k] = (Integer)timeStepsTmp.get(k);
            }
            this.dominatedTimeStepsForGroup.add(timeSteps);
            for (int t = 0; t < this.T; ++t) {
                varianceExplainedCurrent[t] = varianceExplainedUpdate[t][1];
            }
        }
    }

    public void calcOptimizationScheme() {
        TreeSet<Integer> parametersInUse = new TreeSet<Integer>();
        double[] varianceExplainedCurrent = new double[this.T];
        double maxTotalVarianceExplained = 0.0;
        double[] maxVarianceExplained = new double[this.T];
        while (parametersInUse.size() < this.n) {
            boolean addMore = true;
            int[] dominationOfGroup = new int[this.T];
            ParameterGroup group = new ParameterGroup(this.parameter, this.n).createEmptyGroup();
            while (addMore) {
                int bestParameter = -1;
                int bestTimeCover = -1;
                maxTotalVarianceExplained = 0.0;
                maxVarianceExplained = new double[this.T];
                ArrayList<Integer> bestTimeList = null;
                for (int parameter = 0; parameter < this.n; ++parameter) {
                    int t;
                    if (parametersInUse.contains(parameter)) continue;
                    ArrayList<Integer> timeList = new ArrayList<Integer>();
                    TreeSet<Integer> testSet = new TreeSet<Integer>();
                    testSet.addAll(parametersInUse);
                    testSet.add(parameter);
                    double[][] varianceExplainedUpdate = this.VBTSA.calcSensitivity(testSet);
                    double totalVarianceExplained = 0.0;
                    for (t = 0; t < this.T; ++t) {
                        double vt = varianceExplainedUpdate[t][1];
                        totalVarianceExplained += vt;
                        double critValue = this.tau + (1.0 - this.tau) * varianceExplainedCurrent[t];
                        if (!(vt > critValue)) continue;
                        timeList.add(t);
                    }
                    if (timeList.size() <= bestTimeCover && (timeList.size() != bestTimeCover || !(totalVarianceExplained >= maxTotalVarianceExplained))) continue;
                    bestTimeCover = timeList.size();
                    bestParameter = parameter;
                    maxTotalVarianceExplained = totalVarianceExplained;
                    bestTimeList = timeList;
                    for (t = 0; t < this.T; ++t) {
                        maxVarianceExplained[t] = varianceExplainedUpdate[t][1];
                    }
                }
                group.add(bestParameter);
                parametersInUse.add(bestParameter);
                if (!((double)bestTimeList.size() / (double)this.T > this.minDominatedTimesteps) && parametersInUse.size() < this.n) continue;
                addMore = false;
                for (int i = 0; i < bestTimeList.size(); ++i) {
                    dominationOfGroup[i] = (Integer)bestTimeList.get(i);
                }
            }
            varianceExplainedCurrent = maxVarianceExplained;
            this.solutionGroups.add(group);
            this.dominatedTimeStepsForGroup.add(dominationOfGroup);
        }
    }
}

