/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.util.Arrays;
import optas.hydro.OptimizationScheme;
import optas.hydro.ParameterGroup;

public class SimilarityBasedOptimizationScheme
extends OptimizationScheme {
    @Override
    public String toString() {
        return "Similarity";
    }

    private double[] accumulateWeightsOverParameters(double[][] weights) {
        double[] sum = new double[this.T];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.T; ++j) {
                int n = j;
                sum[n] = sum[n] + weights[i][j];
            }
        }
        return sum;
    }

    public double calcR2(double[] t1, double[] t2) {
        double mean = 0.0;
        for (int t = 0; t < this.T; ++t) {
            mean += t1[t];
        }
        mean /= (double)this.T;
        double numerator = 0.0;
        double denumerator = 0.0;
        for (int t = 0; t < this.T; ++t) {
            numerator += (t1[t] - t2[t]) * (t1[t] - t2[t]);
            denumerator += (t1[t] - mean) * (t1[t] - mean);
        }
        if (denumerator == 0.0) {
            return 0.0;
        }
        return 1.0 - numerator / denumerator;
    }

    public double calcr2(double[] t1, double[] t2) {
        double mean_t1 = 0.0;
        double mean_t2 = 0.0;
        for (int t = 0; t < this.T; ++t) {
            mean_t1 += t1[t];
            mean_t2 += t2[t];
        }
        mean_t1 /= (double)this.T;
        mean_t2 /= (double)this.T;
        double numerator = 0.0;
        double denumerator1 = 0.0;
        double denumerator2 = 0.0;
        for (int t = 0; t < this.T; ++t) {
            numerator += (t1[t] - mean_t1) * (t2[t] - mean_t2);
            denumerator1 += (t1[t] - mean_t1) * (t1[t] - mean_t1);
            denumerator2 += (t2[t] - mean_t2) * (t2[t] - mean_t2);
        }
        numerator = 1.0 / (double)this.T * numerator;
        denumerator1 = 1.0 / (double)this.T * denumerator1;
        denumerator2 = 1.0 / (double)this.T * denumerator2;
        if (denumerator1 == 0.0 || denumerator2 == 0.0) {
            return 0.0;
        }
        return numerator / (Math.sqrt(denumerator1) * Math.sqrt(denumerator2));
    }

    public double calcSimilarty(ParameterGroup p1, ParameterGroup p2) {
        double[] w = new double[this.n];
        double[] ts1 = new double[this.T];
        double[] ts2 = new double[this.T];
        for (int t = 0; t < this.T; ++t) {
            for (int i = 0; i < this.n; ++i) {
                w[i] = this.weights[i][t];
            }
            p1.w = w;
            p2.w = w;
            ts1[t] = p1.calcNorm();
            ts2[t] = p2.calcNorm();
        }
        return this.calcr2(ts1, ts2);
    }

    public void calcOptimizationScheme() {
        int currentGroupCount = this.n;
        double[] w_sum = this.accumulateWeightsOverParameters(this.weights);
        ParameterGroup[] groups = new ParameterGroup[this.n];
        for (int i = 0; i < this.n; ++i) {
            groups[i] = new ParameterGroup(this.parameter, this.n).createEmptyGroup();
            groups[i].add(i);
        }
        while (true) {
            double similarity = Double.NEGATIVE_INFINITY;
            int bestP1 = 0;
            int bestP2 = 0;
            for (int i = 0; i < this.n; ++i) {
                for (int j = i + 1; j < this.n; ++j) {
                    double s = this.calcSimilarty(groups[i], groups[j]);
                    if (!(s > similarity)) continue;
                    bestP1 = i;
                    bestP2 = j;
                    similarity = s;
                }
            }
            if (similarity <= 0.0 || currentGroupCount < 2) break;
            System.out.println("Similarity is:" + similarity);
            System.out.println("Group " + groups[bestP1].toString() + " together with " + groups[bestP2].toString());
            groups[bestP1].add(groups[bestP2]);
            groups[bestP2] = groups[--currentGroupCount];
        }
        for (int i = 0; i < currentGroupCount; ++i) {
            this.solutionGroups.add(groups[i]);
            System.out.println("weights group " + i + groups[i]);
            double[] weight_cur = new double[this.T];
            for (int t = 0; t < this.T; ++t) {
                for (int j = 0; j < groups[i].getSize(); ++j) {
                    int n = t;
                    weight_cur[n] = weight_cur[n] + this.weights[groups[i].get(j)][t] / w_sum[t];
                }
            }
            System.out.println(Arrays.toString(weight_cur));
        }
        this.update();
    }

    public class Similarity {
        ParameterGroup p1;
        ParameterGroup p2;
        double similariy;

        public Similarity(ParameterGroup p1, ParameterGroup p2, double similarity) {
            this.p1 = p1;
            this.p2 = p2;
            this.similariy = similarity;
        }
    }
}

